/*
 *   Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de>
 *   Copyright (C) 2003 Christoph Thielecke <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "useradmin.h"
#include <qstring.h>

#ifndef UserAdmin_ADD_H
#define UserAdmin_ADD_H

#include "useradminbaseadduser.h"


/**
 * @short class for adding users
 * @author Ole Behrmann <obehrmann@hbg-bremen.de>
 */
class UserAdminAdd : public UserAdminBaseAddUser {
    Q_OBJECT
public:

  /**
  * Default Constructor
  */
  UserAdminAdd(QString url_system_passwd_file, QString url_system_group_file);

  /**
  * Default Destructor
  */
  ~UserAdminAdd();

  KLineEditDlg *dialog1, *dialog2, *dialog3, *dialog4;

  QProcess *prcAdd;
  QWidget *useMain;
  QString getCurrentUser();
  QString getCurrentGroup();

public slots:
 void slotAddAll();
 void slotAbort();
 void slotClosed();

 void slotEnAcc();
 void slotEnTime();
 void slotEnRatio();

 void slotEnBand();

 //ip slots
 void slotCliIpAcc();
 void slotCliIpAccAdd();
 void slotCliIpAccRem();

 void slotCliIpDen();
 void slotCliIpDenAdd();
 void slotCliIpDenRem();

 void slotLocIpAcc();
 void slotLocIpAccAdd();
 void slotLocIpAccRem();

 void slotLocIpDen();
 void slotLocIpDenAdd();
 void slotLocIpDenRem();

 void slotEnBandwFiles();
 void slotEnBandwSize();
 void slotEnBandwUp();
 void slotEnBandwDown();
 void slotEnBandwConn();

 signals:

void addDialogClosed();


};

#endif
