/**
 * gnomescriptgenerator.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef GNOMESCRIPTGENERATOR_H
#define GNOMESCRIPTGENERATOR_H

#include "interfaces/scriptgenerator.h"

namespace KConfigEditor
{
    class GroupToken;
    class EntryToken;
    class GNOMEScriptGenerator : public ScriptGenerator
    {
    public:
        GNOMEScriptGenerator();
        virtual QString protocol() const { return "gnome"; }

        virtual QString backupScript( const QDict<GroupToken> &topLevelGroups );
        virtual QString propagationScript( const QDict<GroupToken> &topLevelGroups );
        virtual QString fullBackupScript( const QDict<GroupToken> &topLevelGroups );
    protected:
        QString entriesBackup( const QDict<EntryToken> &entries, bool propagate );
    };
}

#endif
