/**
 * gnomescriptgenerator.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "gnomescriptgenerator.h"

#include "grouptoken.h"
#include "entrytoken.h"

#include <qtextstream.h>

using namespace KConfigEditor;

static QString toGConfTypeName( Token::Type type )
{
    switch ( type ) {
    case Token::Int:
        return "int";
        break;
    case Token::Bool:
        return "bool";
        break;
    case Token::Double:
        return "float";
        break;
    case Token::String:
        return "string";
        break;
    default://FIXME: list and pair
        kdWarning()<<"Not Supported entry!!!"<<endl;
        break;
    }

    return QString::null;
}

GNOMEScriptGenerator::GNOMEScriptGenerator()
{
}

QString GNOMEScriptGenerator::backupScript( const QDict<GroupToken> &topLevelGroups )
{
    QString contents;
    QDictIterator<GroupToken> itr( topLevelGroups );
    GroupToken *topGroup =0;

    while ( (topGroup=itr.current()) ) {
        if ( topGroup->hasPendingChanges() ) {
            contents += entriesBackup( topGroup->modifiedEntries(), false );
        }
        ++itr;
    }

    return contents;
}

QString GNOMEScriptGenerator::propagationScript( const QDict<GroupToken> &topLevelGroups )
{
    QString contents;
    QDictIterator<GroupToken> itr( topLevelGroups );
    GroupToken *topGroup =0;

    while ( (topGroup=itr.current()) ) {
        if ( topGroup->hasPendingChanges() ) {
            contents += entriesBackup( topGroup->modifiedEntries(), true );
        }
        ++itr;
    }

    return contents;
}

QString GNOMEScriptGenerator::fullBackupScript( const QDict<GroupToken> &topLevelGroups )
{
    Q_UNUSED( topLevelGroups );
    return QString( "# FIXME" );
}

QString GNOMEScriptGenerator::entriesBackup( const QDict<EntryToken> &entries, bool propagate )
{
    QString str;
    QTextStream ts( &str, IO_WriteOnly );

    QDictIterator<EntryToken> itr( entries );
    EntryToken *token = 0;
    while ( (token=itr.current()) ) {
        QString typeName = toGConfTypeName( token->type() );
        if ( !typeName.isEmpty() ) {
            QString value = propagate ? token->valueAsString() : token->initialValueAsString();
            if ( token->type() == Token::String ) {
                value = value.replace( '\"', "\\\"" );
                value = value.replace( '\'', "\\\'" );
                value = QString( "\'%1\'" ).arg( value );
            }

            ts << "shell( \""
               << "gconftool-2 --set " << token->url().path()
               << " --type " << typeName <<" "<< value << "\" );\n";
        }
        ++itr;
    }

    return str;
}
