/**
 * entries.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_ENTRIES_H
#define KONFIG_ENTRIES_H

#include "entrytoken.h"

#include <qfont.h>
#include <qcolor.h>
#include <qrect.h>
#include <qpoint.h>
#include <qsize.h>
#include <qdatetime.h>
#include <qstring.h>

namespace KConfigEditor
{

    class StringEntry : public EntriesBase<QString>
    {
    public:
        StringEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& value );

        QString typeName() const { return "String"; }
        Type    type() const { return String; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class StringListEntry : public EntriesBase<QStringList>
    {
    public:
        StringListEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& value );

        QString typeName() const { return "StringList"; }
        Type    type() const     { return StringList;   }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class FontEntry : public EntriesBase<QFont>
    {
    public:
        FontEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Font"; }
        Type    type() const { return Font; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class RectEntry : public EntriesBase<QRect>
    {
    public:
        RectEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Rect"; }
        Type    type() const { return Rect; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class SizeEntry : public EntriesBase<QSize>
    {
    public:
        SizeEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Size"; }
        Type    type() const { return Size; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class PointEntry : public EntriesBase<QPoint>
    {
    public:
        PointEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Point"; }
        Type    type() const { return Point; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class ColorEntry : public EntriesBase<QColor>
    {
    public:
        ColorEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Color"; }
        Type    type() const { return Color; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class IntEntry : public EntriesBase<int>
    {
    public:
        IntEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Int"; }
        Type    type() const { return Int; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class UIntEntry : public EntriesBase<uint>
    {
    public:
        UIntEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "UInt"; }
        Type    type() const { return UInt; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class BoolEntry : public EntriesBase<bool>
    {
    public:
        BoolEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Bool"; }
        Type    type() const { return Bool; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class DoubleEntry : public EntriesBase<double>
    {
    public:
        DoubleEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Double"; }
        Type    type() const { return Double; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class DateTimeEntry : public EntriesBase<QDateTime>
    {
    public:
        DateTimeEntry( GroupToken* parent, const QString& name, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "DateTime"; }
        Type    type() const { return DateTime; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class Int64Entry : public EntriesBase<Q_LLONG>
    {
    public:
        Int64Entry( GroupToken* parent, const QString& name, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Int64"; }
        Type    type() const { return Int64; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class UInt64Entry : public EntriesBase<Q_ULLONG>
    {
    public:
        UInt64Entry( GroupToken* parent, const QString& name, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "UInt64"; }
        Type    type() const { return UInt64; }

        virtual QVariant initialValue() const {
            return QVariant( m_initialValue );
        }
    };

    class IntListEntry : public EntriesBase< QValueList<int> >
    {
    public:
        IntListEntry( GroupToken* parent, const QString& name, bool hidden=false  );

        QVariant variant() const;
        void setVariant( const QVariant&  );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "IntList"; }
        Type    type() const { return IntList; }

        virtual QVariant initialValue() const;
    };

    class EnumEntry : public EntriesBase< QValueList<int> >
    {
    public:
        // XXX : this is wrong
        EnumEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& );

        QString typeName() const { return "Enum"; }
        Type    type() const { return Enum; }

        virtual QVariant initialValue() const;
    };

    class PathEntry : public EntriesBase<KURL>
    {
    public:
        PathEntry( GroupToken* parent, const QString& name, bool hidden=false );

        QVariant variant() const;
        void setVariant( const QVariant& var );

        QString initialValueAsString() const;

        QString  valueAsString() const;
        void setValueFromString( const QString& val );

        QString typeName() const { return "Path"; }
        Type    type() const { return Path; }

        virtual QVariant initialValue() const;
    };

}

#endif
