/**
 * parserinterface.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_PARSERINTERFACE_H
#define KONFIG_PARSERINTERFACE_H

#include <qobject.h>
#include <qptrlist.h>

class KURL;

namespace KCfgCreator
{
    class HostData;
    class FileData;
    class HostToken;
    class ApplicationToken;

    class ParserInterface : public QObject
    {
        Q_OBJECT
    public:
        ParserInterface( QObject* parent, const char* name=0 );

        virtual ApplicationToken* parseDataMerging( ApplicationToken* app,
                                                    FileData* data ) =0;

        virtual ApplicationToken* parseAndAddFile( HostToken* parent,
                                                   FileData* fdata ) =0;
    public slots:
        virtual void parseData( HostData* )=0;
    signals:
        void parsed( HostToken* token );
    };
}

#endif
