/**
 * kcfgcoptions.h
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCFGCOPTIONS_H
#define KCFGCOPTIONS_H

#include <qstringlist.h>
#include <qstring.h>

class KListView;

namespace KCfgCreator
{
    class KCfgcOptions
    {
    public:
        static KCfgcOptions* self();
    public:

        void setListView( KListView* );

        void save();

        void fromRcFile( const QString& file );

        void kcfgcFromFile( const QString& file );
        void kcfgcToFile( const QString& file );

        void kcfgFromFile( const QString& file );

        QString configName() const;
        void setConfigName( const QString& name );

        QString kcfgFile() const;
        void setKCfgFile( const QString& );

        QString namespaceName() const;
        void setNamespaceName( const QString& );

        QString className() const;
        void setClassName( const QString& );

        QString inherits() const;
        void setInherits( const QString& );

        bool singleton() const;
        void setSingleton( bool );

        QString memberVariables() const;
        void setMemberVariables( const QString& );

        QStringList includeFiles() const;
        void setIncludeFiles( const QStringList& );

        bool mutators() const;
        void setMutators( bool );

        bool itemAccessors() const;
        void setItemAccessors( bool );

        bool userTexts() const;
        void setUserText( bool );

        bool globalEnums() const;
        void setGlobalEnums( bool );
    private:
        KCfgcOptions();
        static KCfgcOptions* s_self;
    private:
        KListView *m_lv;

        QString      m_fileName;
        QString      m_kcfgFile;
        QString      m_namespace;
        QString      m_className;
        QString      m_inherits;
        bool         m_singleton;
        QString      m_memberVariables;
        QStringList  m_includeFiles;
        bool         m_mutators;
        bool         m_itemAccessors;
        bool         m_userTexts;
        bool         m_globalEnums;
    };
}

#endif
