/***************************************************************************
                               main.cpp  -  description
                             -------------------
    begin                : Die Mr 20 20:13:29 CET 2001
    copyright            : (C) 2001 by Jochen Schmitt
    email                : Jochen@herr-schmitt.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "kurllaunch.h"
#include "kurllaunch_rc.h"

#include "mybrowserinfo.h"

static const char *description =
	I18N_NOOP("KURLLaunch");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[FILES}", I18N_NOOP("Files"), 0},
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

MyBrowserInfo *gmbinfo;

int main(int argc, char *argv[])
{
	int rc = 0;
	
  KAboutData aboutData( "kurllaunch", I18N_NOOP("KURLLaunch"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2001, Jochen Schmitt", 0, 0, "Jochen@herr-schmitt.de");
  aboutData.addAuthor("Jochen Schmitt",0, "Jochen@herr-schmitt.de");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;

 	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
 	
 	int count = args->count();

 	gmbinfo = new MyBrowserInfo();
 	 	
 	if (count == 0)
 	{
  	KURLLaunch *kurllaunch = new KURLLaunch();
  	a.setMainWidget(kurllaunch);
  	kurllaunch->show();
  	rc = a.exec();
  	if(gmbinfo->changed())
  	{
  		if(KMessageBox::questionYesNo(0, i18n("Would you want to save the changes?"),
  	    	                             i18n("Save Changes")) == KMessageBox::Yes)
  			gmbinfo->saveProfile();
  	}
  }
  else
  {
  	for(int i=0;i<count;i++)
  		gmbinfo->Exec(args->arg(i));
  }		

  return rc;
}
