/***************************************************************************
                          ksteakmainwindow.cpp  -  description
                             -------------------
    begin                : Sat Nov 14 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksteakmainwindow.h"
#include <qtooltip.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kaccel.h>
#include <kwin.h>
#include <kmenubar.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdatetbl.h>
#include <qmultilineedit.h>
#include <stdio.h>

/************************************
 * constructor - main widget        *
 ************************************/
KSteakMainWindow::KSteakMainWindow()
{
  //set MainWidget
  KSteakWidget = new Ksteak(this);
  setView(KSteakWidget);
	
  //create DockWidget
  SteakDock = new dockwidget(0);
  SteakDock->setPixmap(BarIcon("ksteak.png"));
  connect(SteakDock, SIGNAL(undock()), this, SLOT(slotUndock()));
  connect(SteakDock, SIGNAL(done()), this, SLOT(slotQuit()));
  connect(SteakDock, SIGNAL(translate()), this, SLOT(slotTranslate()));
	
  //MenuBar
  QPopupMenu *filemenu = new QPopupMenu();
  filemenu->insertItem(i18n("&Dock to Panel"), this, SLOT(slotDock()), CTRL+Key_D);
  filemenu->insertSeparator();
  filemenu->insertItem(i18n("&Quit"), this, SLOT(slotQuit()), CTRL+Key_Q);

  viewmenu = new QPopupMenu();
  viewmenu->insertItem(i18n("&Toolbar"), this, SLOT(slotToggleToolbar()), 0, 1);
  viewmenu->setCheckable(TRUE);
  viewmenu->setItemChecked(1, TRUE);

  searchmenu = new QPopupMenu();
  searchmenu->insertItem(i18n("&English"), 2);
  searchmenu->insertItem(i18n("&German"), 3);
  searchmenu->insertSeparator();
  searchmenu->insertItem(i18n("Display &Context"), 4);
  searchmenu->insertItem(i18n("Case &sensitive"), 5);
  searchmenu->insertSeparator();
  searchmenu->insertItem(i18n("&AND"), 6);
  searchmenu->insertItem(i18n("&OR"), 7);
  searchmenu->setCheckable(TRUE);
  connect(searchmenu, SIGNAL(activated(int)), this, SLOT(slotMenuClicked(int)));

  menuBar()->insertItem(i18n("&File"), filemenu);
  menuBar()->insertItem(i18n("&Search"), searchmenu);
  menuBar()->insertItem(i18n("&View"), viewmenu);
  helpmenu = helpMenu("");
  menuBar()->insertItem(i18n("&Help"), helpmenu);

  //ToolBar
  toolBar()->insertButton(BarIcon("exit.png"), TOOLBAR_EXIT, true, i18n("Quit"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("find.png"), TOOLBAR_SEARCH, true, i18n("Search"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("flag-en.png"), TOOLBAR_ENG, true, i18n("English"));
  toolBar()->insertButton(BarIcon("flag-de.png"), TOOLBAR_GER, true, i18n("German"));
  toolBar()->insertButton(BarIcon("contents.png"), TOOLBAR_CONTEXT, true, i18n("Context"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(BarIcon("case.png"), TOOLBAR_SENSITIVE, true, i18n("Case Sensitive"));
  toolBar()->insertButton(BarIcon("and.png"), TOOLBAR_AND, true, i18n("AND"));
  toolBar()->insertButton(BarIcon("or.png"), TOOLBAR_OR, true, i18n("OR"));
  connect(toolBar(), SIGNAL(clicked(int)), this, SLOT(slotToolbarClicked(int)));
  //set toggle-buttons
  toolBar()->setToggle(TOOLBAR_ENG, TRUE);
  toolBar()->setToggle(TOOLBAR_GER, TRUE);
  toolBar()->setToggle(TOOLBAR_CONTEXT, TRUE);
  toolBar()->setToggle(TOOLBAR_SENSITIVE, TRUE);
  toolBar()->setToggle(TOOLBAR_AND, TRUE);
  toolBar()->setToggle(TOOLBAR_OR, TRUE);

  //reading config-file
  ReadConfig();
}

/*****************************************
 * destructor                            *
 *****************************************/
KSteakMainWindow::~KSteakMainWindow()
{
}

/*****************************************
 toggle Toolbar
 *****************************************/
void KSteakMainWindow::slotToggleToolbar(void)
{
  if (viewmenu->isItemChecked(1))
    {
      viewmenu->setItemChecked(1, FALSE);
      enableToolBar(KToolBar::Hide);
    }
  else
    {
      viewmenu->setItemChecked(1, TRUE);
      enableToolBar(KToolBar::Show);
    }
}

/*****************************************
 handle Toolbar-Events
 *****************************************/
void KSteakMainWindow::slotToolbarClicked(int id)
{
  switch(id)
    {
    case 0:	
      slotQuit();
      break;
    case 1:	
      KSteakWidget->getTranslation(-1);
      break;
    case 2:	
      if (KSteakWidget->English) KSteakWidget->English=FALSE;
      else KSteakWidget->English=TRUE;
      searchmenu->setItemChecked(2, KSteakWidget->English);
      break;
    case 3:	
      if (KSteakWidget->German) KSteakWidget->German=FALSE;
      else KSteakWidget->German=TRUE;
      searchmenu->setItemChecked(3, KSteakWidget->German);
      break;
    case 4:	
      if (KSteakWidget->Context) KSteakWidget->Context=FALSE;
      else KSteakWidget->Context=TRUE;
      searchmenu->setItemChecked(4, KSteakWidget->Context);
      break;
    case 5:	
      if (KSteakWidget->Sensitive) KSteakWidget->Sensitive=FALSE;
      else KSteakWidget->Sensitive=TRUE;
      searchmenu->setItemChecked(5, KSteakWidget->Sensitive);
      break;
    case 6:	
      if (KSteakWidget->SearchAnd) KSteakWidget->SearchAnd=FALSE;
      else KSteakWidget->SearchAnd=TRUE;
      searchmenu->setItemChecked(6, KSteakWidget->SearchAnd);
      if (KSteakWidget->SearchOr)	//AND + OR exlusive
	{
	  KSteakWidget->SearchOr=FALSE;
	  searchmenu->setItemChecked(7, FALSE);
	  toolBar()->toggleButton(7);
	}
      break;
    case 7:	
      if (KSteakWidget->SearchOr) KSteakWidget->SearchOr=FALSE;
      else KSteakWidget->SearchOr=TRUE;
      searchmenu->setItemChecked(7, KSteakWidget->SearchOr);
      if (KSteakWidget->SearchAnd) //AND + OR exlusive
	{
	  KSteakWidget->SearchAnd=FALSE;
	  searchmenu->setItemChecked(6, FALSE);
	  toolBar()->toggleButton(6);
	}
      break;
    }
}

/*****************************************
 handle Menubar-Events
 *****************************************/
void KSteakMainWindow::slotMenuClicked(int id)
{
  toolBar()->toggleButton(id);
  slotToolbarClicked(id);
}

/*****************************************
 save Config (state of Toolbar-Buttons)
 *****************************************/
void KSteakMainWindow::SaveConfig(void)
{
  int i;
  KConfig *config = kapp->config();
  config->setGroup(0);
  //save Dock-state
  config->writeEntry("docked", KSteakWidget->docked);
  //save buttons state
  config->writeEntry("English", KSteakWidget->English);
  config->writeEntry("German", KSteakWidget->German);
  config->writeEntry("Context", KSteakWidget->Context);
  config->writeEntry("Sensitive", KSteakWidget->Sensitive);
  config->writeEntry("SearchAnd", KSteakWidget->SearchAnd);
  config->writeEntry("SearchOr", KSteakWidget->SearchOr);
  //save Combobox history
  config->setGroup("Combobox");
  i = KSteakWidget->LineSearch->count()-1;
  if (i >= 0) config->writeEntry("History1", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History2", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History3", KSteakWidget->LineSearch->text(i)); 	i--;
  if (i >= 0) config->writeEntry("History4", KSteakWidget->LineSearch->text(i));
  //save toolbar state
  config->setGroup("Toolbar");
  config->writeEntry("visible", viewmenu->isItemChecked(1));
  //write config-file
  config->sync();
}

/*****************************************
 read Config
 *****************************************/
void KSteakMainWindow::ReadConfig(void)
{
  KConfig *config = kapp->config();
  config->setGroup(0);
  if (config->readBoolEntry("docked")) slotDock();
  else slotUndock();
  if (config->readBoolEntry("English")) slotMenuClicked(TOOLBAR_ENG);
  if (config->readBoolEntry("German")) slotMenuClicked(TOOLBAR_GER);
  if (config->readBoolEntry("Context")) slotMenuClicked(TOOLBAR_CONTEXT);
  if (config->readBoolEntry("Sensitive")) slotMenuClicked(TOOLBAR_SENSITIVE);
  if (config->readBoolEntry("SearchAnd")) slotMenuClicked(TOOLBAR_AND);
  if (config->readBoolEntry("SearchOr")) slotMenuClicked(TOOLBAR_OR);
  config->setGroup("Combobox");
  if (config->hasKey("History1")) KSteakWidget->LineSearch->insertItem(config->readEntry("History1"), -1);
  if (config->hasKey("History2")) KSteakWidget->LineSearch->insertItem(config->readEntry("History2"), -1);
  if (config->hasKey("History3")) KSteakWidget->LineSearch->insertItem(config->readEntry("History3"), -1);
  if (config->hasKey("History4")) KSteakWidget->LineSearch->insertItem(config->readEntry("History4"), -1);
  KSteakWidget->LineSearch->clearEdit();
  config->setGroup("Toolbar");
  if (!config->readBoolEntry("visible")) slotToggleToolbar();
}

/*****************************************
 save history before quit
 *****************************************/
void KSteakMainWindow::slotQuit(void)
{
  SaveConfig();
  kapp->quit();
}


/*****************************************
 session management - save settings
 *****************************************/
void KSteakMainWindow::saveProperties(KConfig *kconfig)
{
  SaveConfig();
}


/*****************************************
 show dockwidget + hide mainwidget
 *****************************************/
void KSteakMainWindow::slotDock(void)
{
  SteakDock->show();
  this->hide();
  KSteakWidget->docked = 1;
}

/*****************************************
 hide dockwidget + show mainwidget
 *****************************************/
void KSteakMainWindow::slotUndock(void)
{
  this->show();
  if (KSteakWidget->docked)
    {
      SteakDock->hide();
      KSteakWidget->docked = 0;
    }
}

/*****************************************
 create a popup help-window
 *****************************************/
void KSteakMainWindow::slotTranslate(void)
{
  //create Popup-window
  KPopupFrame *mypop = new KPopupFrame(this);

  //we dont need decorations
  mypop->setFrameStyle(QFrame::Box | QFrame::Plain);
  mypop->setLineWidth(1);
	
  //text-viewer widget
  QMultiLineEdit *myview = new QMultiLineEdit(mypop);
  myview->setFrameStyle(QFrame::NoFrame);
  myview->setReadOnly(true);
  myview->setPalette(QPalette(QColor(255, 255, 200)));
  KSteakWidget->getTranslation(-1);
  myview->setText(KSteakWidget->ViewSteak->text());

  //set widget-size
  QRect r = myview->fontMetrics().boundingRect( 0, 0, QApplication::desktop()->width()/2, 400, AlignLeft + AlignTop + WordBreak + ExpandTabs, myview->text() );
  int w = r.width()+6;
  int h = r.height()+6;
  myview->setGeometry(1,1,w,h);
	
  //clever placement
  if (QCursor::pos().x()-w < 1) w = 0;
  if (QCursor::pos().y()-h < 1) h = 0;

  mypop->setMainWidget(myview);
  mypop->exec(QCursor::pos().x()-w, QCursor::pos().y()-h);
}
