  /*

  knetfilter v 2.1.1

  Copyright (C) 2001 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"


// sending commands to set up rules
void knetfilter::addRule() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));
    
    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));
    
    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));


    addp.clearArguments();
    addp2.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }


    if(sport.length()==0 && dport.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or destination port number.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (strcmp("nostate",stateChoice)==0)
      {
	if (dport.length()==0)
	  {
	    addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    addp2 << "iptables" << ruleaction << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	  }
	else
	  {
	    if (sport.length()==0)
	      {
		addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      }
	    else
	      {
		addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      }
	  }
      }
      else
	{
	  if (strcmp("unclean",stateChoice)==0)
	    {
	      state_modules = "unclean";
	      state_definition = "-v";
	      stateChoice = "-v";
	    }
	  else
	    {
	      state_modules = "state"; 
	      state_definition = "--state";
	    }
	  if (dport.length()==0)
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      addp2 << "iptables" << ruleaction << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	  else
	    {
	      if (sport.length()==0)
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	      else
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }
	}
    };

    bool success=addp.start();
    bool success2=addp2.start();
    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_tcp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));


    addp.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(sport.length()==0 && dport.length()==0 ) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or destination port number.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (strcmp("nostate",stateChoice)==0)
	{
	  if (dport.length()==0)
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }      
	}
      else
	{
	  if (strcmp("unclean",stateChoice)==0)
	    {
	      state_modules = "unclean";
	      state_definition = "-v";
	      stateChoice = "-v";
	    }
	  else
	    {
	      state_modules = "state"; 
	      state_definition = "--state";
	    }
	  if (dport.length()==0)
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  addp << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }      	  
	}	
    };
      
    bool success=addp.start();
    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_udp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));

    addp2.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(sport.length()==0 && dport.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or detination port number.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (strcmp("nostate",stateChoice)==0)
	{
	  if (dport.length()==0)
	    {
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }
	}
      else
	{
	  if (strcmp("unclean",stateChoice)==0)
	    {
	      state_modules = "unclean";
	      state_definition = "-v";
	      stateChoice = "-v";
	    }
	  else
	    {
	      state_modules = "state"; 
	      state_definition = "--state";
	    }
	  if (dport.length()==0)
	    {
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }
	}
    };

    bool success2=addp2.start();

    if (success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_icmp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, type, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("32");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("32");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    type.sprintf((const char *)(addIcmpType->text()));

    addp3.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(type.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply an icmp type number.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (strcmp("nostate",stateChoice)==0)
	{
	  addp3 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	}
      else
	{
	  if (strcmp("unclean",stateChoice)==0)
	    {
	      state_modules = "unclean";
	      state_definition = "-v";
	      stateChoice = "-v";
	    }
	  else
	    {
	      state_modules = "state"; 
	      state_definition = "--state";
	    }
	  addp3 << "iptables" << ruleaction << chainChoice << rulepos << "-m" << state_modules << state_definition << stateChoice << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	}
    };

    bool success=addp3.start();
    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::delRule() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp.clearArguments();
    delp2.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp << "iptables" << "-D" << chainChoice << rulepos;
	delp2;	  
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (strcmp("nostate",stateChoice)==0)
	    {
	      if (dport.length()==0)
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	      else
		{
		  if (sport.length()==0)
		    {
		      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		  else
		    {
		      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}
	    }
	  else
	    {
	      if (strcmp("unclean",stateChoice)==0)
		{
		  state_modules = "unclean";
		  state_definition = "-v";
		  stateChoice = "-v";
		}
	      else
		{
		  state_modules = "state"; 
		  state_definition = "--state";
		}
	      if (dport.length()==0)
		{
		  delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	      else
		{
		  if (sport.length()==0)
		    {
		      delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		      delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		  else
		    {
		      delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		      delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}
	    }
	}
      };

    bool success=delp.start();
    bool success2=delp2.start();

    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::delRule_tcp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }


    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (strcmp("nostate",stateChoice)==0)
	    {
	      if (dport.length()==0)
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  if (sport.length()==0)	
		    {
		      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		    }
		  else
		    {
		      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}      
	    }
	  else
	    {
	      if (strcmp("unclean",stateChoice)==0)
		{
		  state_modules = "unclean";
		  state_definition = "-v";
		  stateChoice = "-v";
		}
	      else
		{
		  state_modules = "state"; 
		  state_definition = "--state";
		}
	      if (dport.length()==0)
		{
		  delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  if (sport.length()==0)	
		    {
		      delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		    }
		  else
		    {
		      delp << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}      
	    }
	}
      };

    bool success=delp.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::delRule_udp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("255.255.255.255");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp2.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp2 << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (strcmp("nostate",stateChoice)==0)
	    {
	      if (dport.length()==0)
		{
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  if (sport.length()==0)	
		    {
		      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		    }
		  else
		    {
		      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}
	    }
	  else
	    {
	      if (strcmp("unclean",stateChoice)==0)
		{
		  state_modules = "unclean";
		  state_definition = "-v";
		  stateChoice = "-v";
		}
	      else
		{
		  state_modules = "state"; 
		  state_definition = "--state";
		}
	      if (dport.length()==0)
		{
		  delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  if (sport.length()==0)	
		    {
		      delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		    }
		  else
		    {
		      delp2 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		    }
		}
	    }
	}
    };

    bool success2=delp2.start();

    if (success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::delRule_icmp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, type, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    if(netmask.length()==0)
      {
	netmask.sprintf("32");
      }

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmask));

    extramask.sprintf((const char *)(extraNetMask->text()));

    if(extramask.length()==0)
      {
	extramask.sprintf("32");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    type.sprintf((const char *)(addIcmpType->text()));


    delp3.clearArguments();

    if(ip.length()==0)
      {
	network.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(ipAddr->text()),"0.0.0.0")==0))
    {      
      network.sprintf("0.0.0.0/0");
    }

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp3 << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(type.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter an icmp type number\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (strcmp("nostate",stateChoice)==0)
	    {
	      delp3 << "iptables" << "-D" << chainChoice << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	  else
	    {
	      if (strcmp("unclean",stateChoice)==0)
		{
		  state_modules = "unclean";
		  state_definition = "-v";
		  stateChoice = "-v";
		}
	      else
		{
		  state_modules = "state"; 
		  state_definition = "--state";
		}
	      delp3 << "iptables" << "-D" << chainChoice << "-m" << state_modules << state_definition << stateChoice << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	}
      };
	
    bool success=delp3.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::stopAll() {

    stop.clearArguments(); 
    stop << "iptables" << "-F";
    bool success=stop.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};


void knetfilter::stopNAT() {

    stop_nat.clearArguments(); 
    stop_nat << "iptables" << "-t" << "nat" << "-F";
    bool success=stop_nat.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};

void knetfilter::stopMangle() {

    stop_mangle.clearArguments(); 
    stop_mangle << "iptables" << "-t" << "mangle" << "-F";
    bool success=stop_mangle.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};


void knetfilter::saveAll() {

  save.clearArguments();

  FILE *cfgfile;
  FILE *saver1;
  FILE *saver2;
  FILE *saver3;
  FILE *saver4;
  FILE *saver5;
  FILE *saver6;
  FILE *restore1;
  FILE *restore2;
  FILE *restore3;
  FILE *restore4;
  FILE *restore5;
  FILE *restore6;

  cfgfile = fopen("/etc/iptables.cfg", "r");
  saver1 = fopen ("/bin/iptables-save", "r");
  saver2 = fopen ("/sbin/iptables-save", "r");
  saver3 = fopen ("/usr/bin/iptables-save", "r");
  saver4 = fopen ("/usr/sbin/iptables-save", "r");
  saver5 = fopen ("/usr/local/bin/iptables-save", "r");
  saver6 = fopen ("/usr/local/sbin/iptables-save", "r");
  restore1 = fopen ("/bin/iptables-restore", "r");
  restore2 = fopen ("/sbin/iptables-restore", "r");
  restore3 = fopen ("/usr/bin/iptables-restore", "r");
  restore4 = fopen ("/usr/sbin/iptables-restore", "r");
  restore5 = fopen ("/usr/local/bin/iptables-restore", "r");
  restore6 = fopen ("/usr/local/sbin/iptables-restore", "r");

  if ( saver1==NULL && saver2==NULL && saver3==NULL && saver4==NULL && saver5==NULL && saver6==NULL || restore1==NULL && restore2==NULL && restore3==NULL && restore4==NULL && restore5==NULL && restore6==NULL )
    {
      QMessageBox::information(this, "Warning",
			      "Couldn't locate iptables-save binary from iptables-1.2.1a or newer.\n"
			      "For now I will use my own save function, but, please, consider\n"
			      "to upgrade your iptables as soon, enabling it's own\n"
			      "iptables-save and iptables-restore command lines. (SEE iptables README)."); 

      save << "kiptables-save";
    }
  else
    {
      if ( cfgfile != NULL)
	{
	  remove("/etc/iptables.cfg");
	}
      save  << "kiptables-save" << "iptorig";  
    } 

  // to be removed when iptables-save will work
  // save << "kiptables-save";

  bool success=save.start();

  if (success)
    statusbar->message(i18n("Saving..."), 2000);
  else
    statusbar->message(i18n("Couldn't save iptables"), 2000);

  /*  fclose (cfgfile);
  fclose (saver1);
  fclose (saver2);
  fclose (saver3);
  fclose (saver4);
  fclose (saver5);
  fclose (saver6);
  fclose (restore1);
  fclose (restore2);
  fclose (restore3);
  fclose (restore4);
  fclose (restore5);
  fclose (restore6);*/
};


void knetfilter::loadAll() {

  load.clearArguments();
  

  FILE *cfgfile_2;
  FILE *saver1_2;
  FILE *saver2_2;
  FILE *saver3_2;
  FILE *saver4_2;
  FILE *saver5_2;
  FILE *saver6_2;
  FILE *restore1_2;
  FILE *restore2_2;
  FILE *restore3_2;
  FILE *restore4_2;
  FILE *restore5_2;
  FILE *restore6_2;

  cfgfile_2 = fopen("/etc/iptables.cfg", "r");
  saver1_2 = fopen ("/bin/iptables-save", "r");
  saver2_2 = fopen ("/sbin/iptables-save", "r");
  saver3_2 = fopen ("/usr/bin/iptables-save", "r");
  saver4_2 = fopen ("/usr/sbin/iptables-save", "r");
  saver5_2 = fopen ("/usr/local/bin/iptables-save", "r");
  saver6_2 = fopen ("/usr/local/sbin/iptables-save", "r");
  restore1_2 = fopen ("/bin/iptables-restore", "r");
  restore2_2 = fopen ("/sbin/iptables-restore", "r");
  restore3_2 = fopen ("/usr/bin/iptables-restore", "r");
  restore4_2 = fopen ("/usr/sbin/iptables-restore", "r");
  restore5_2 = fopen ("/usr/local/bin/iptables-restore", "r");
  restore6_2 = fopen ("/usr/local/sbin/iptables-restore", "r");

  if ( cfgfile_2 == NULL )
    {
      QMessageBox::information(this, "Warning",
			       "It seem that yoh do not have a\n"
			       "previouslt saved configuration.");
    }
  else
    {
      if ( saver1_2==NULL && saver2_2==NULL && saver3_2==NULL && saver4_2==NULL && saver5_2==NULL && saver6_2==NULL || restore1_2==NULL && restore2_2==NULL && restore3_2==NULL && restore4_2==NULL && restore5_2==NULL && restore6_2==NULL )
	{
	  QMessageBox::information(this, "Warning",
				   "Couldn't locate iptables-save binary from iptables-1.2.1a or newer.\n"
				   "For now I will use my own save function, but, please, consider\n"
				   "to upgrade your iptables as soon, enabling it's own\n"
				   "iptables-save and iptables-restore command lines. (SEE iptables README)."); 
	  load << "kiptables-restore"; 
	}
      else
	{
	  load << "kiptables-restore"; 
	  // not needed since kiptables-save script is smarter than i thought
	  // anyway, i want to advise if users should upgrade
	  //	  load << "kiptables-restore" << "iptorig"; 
	}
    }

  // to be removed when iptables-restore will work
  // load << "kiptables-restore"; 

  bool success=load.start();

  if (success)
    statusbar->message(i18n("Saving..."), 2000);
  else
    statusbar->message(i18n("Couldn't save iptables"), 2000);

  /*  fclose (cfgfile_2);
  fclose (saver1_2);
  fclose (saver2_2);
  fclose (saver3_2);
  fclose (saver4_2);
  fclose (saver5_2);
  fclose (saver6_2);
  fclose (restore1_2);
  fclose (restore2_2);
  fclose (restore3_2);
  fclose (restore4_2);
  fclose (restore5_2);
  fclose (restore6_2); */
};



// log facilities
void knetfilter::addDone_tcp() {

  if (addp.normalExit() && (addp.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for tcp packets, source port %s, destination port %s, %s chain",policyChoice, (const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
  statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::addDone_udp() {

  if (addp2.normalExit() && (addp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for udp packets, source port %s, destination port %s, %s chain",policyChoice, (const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);

    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::addDone_icmp() {

  if (addp3.normalExit() && (addp3.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for icmp of type %s incoming, %s chain",policyChoice,(const char *)(addIcmpType->text()),chainChoice);
    messageLog->insertItem(msg);
    addIcmpType->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};


void knetfilter::delDone_tcp() {

  if (delp.normalExit() && (delp.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s for tcp packets, source port %s, destination port %s, %s chain, DELETED",policyChoice,(const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::delDone_udp() {

  if (delp2.normalExit() && (delp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s for udp packets, source port %s, destination port %s, %s chain,  DELETED",policyChoice,(const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::delDone_icmp() {

  if (delp3.normalExit() && (delp3.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s icmp of type %s incoming, %s chain, DELETED",policyChoice,(const char *)(addIcmpType->text()),chainChoice);
    messageLog->insertItem(msg);
    addIcmpType->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};


void knetfilter::saveDone() {

  if (save.normalExit() && (save.exitStatus()==0)) {
    statusbar->message(i18n("All rules saved"), 2000);
    messageLog->insertItem("Configuration Rules has been saved");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables-save died"), 2000);

};


void knetfilter::loadDone() {

  if (load.normalExit() && (load.exitStatus()==0)) {
    statusbar->message(i18n("All rules loaded"), 2000);
    messageLog->insertItem("Configuration Rules has been restored");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables-restore died"), 2000);

};


void knetfilter::stopDone() {

  if (stop.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All rules flushed"), 2000);
    messageLog->insertItem("All ports are now open");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};


void knetfilter::stop_natDone() {

  if (stop_nat.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All nat rules flushed"), 2000);
    messageLog->insertItem("All redirections are now flushed");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};

void knetfilter::stop_mangleDone() {

  if (stop_mangle.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All mangle rules flushed"), 2000);
    messageLog->insertItem("All magle rules are now flushed");
//    addmangleSourcePort->setFocus();
//    addmangleDestinationPort->setFocus();
//    addmangleIcmpType->setFocus();
//    addmangleRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};


// log cleaner
void knetfilter::clearLog() {

  messageLog->clear();
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};
