/*
    KMLOFax
    
    A utility to process facsimiles received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2001 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
    PostScript(R) is a registered trademark of Adobe Systems Incorporated.
*/

#ifndef PRINTDLG_H
#define PRINTDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qstring.h>

#include <kdialog.h>
#include <kconfig.h>



class PrintDlg : public KDialog
{
	Q_OBJECT
public:
	PrintDlg(QWidget *parent = 0, const char *name = 0);
	~PrintDlg();

	void addToolTips(bool on);

	void printFax(const QString& name);

protected slots:
	void slotBrowse();
	
	void slotHelp();
	void slotOk();

	void destinationSelected(int id_);
	void formatSelected(int id_);
	void level2Selected(bool on);

private:
	KConfig *config;

	bool gotToolTips;

	bool to_printer;
	int paper_num;

	QButtonGroup *destination;
	QLineEdit *printer;
	QLineEdit *file;
	QPushButton *browse;

	QSpinBox *from_page;
	QSpinBox *to_page;
	QSpinBox *copies;
	QCheckBox *level2;
	QCheckBox *interpolate;

	QButtonGroup *paper_format;

	QString m_name;
};


extern PrintDlg *printdlg;

#endif // PRINTDLG_H
