/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef KMLOCFG_H 
#define KMLOCFG_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlabel.h>

#include <kmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>

#include "configure.h"
#include "loaddlg.h"
#include "setupdlg.h"


class KMLOCfg : public KMainWindow
{
	Q_OBJECT
public:
	KMLOCfg(QWidget *parent = 0, const char *name = 0);
	virtual ~KMLOCfg();

	void enableCommand(int id_, bool enable);

protected:
	void readOptions();
	void saveOptions();

	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initKeyAccel();
	void initWhatsThis();

public slots:
	void commandCallback(int id_);

	void slotFileDownload();
	void slotFileUpload();
	void slotFileNew();
	void slotFileEdit();
	void slotFileQuit();
	
	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	void slotSettingsConfigure();

	void slotStatusMsg(const QString& text);
	void slotStatusHelpMsg(const QString& text);

private slots:
	void slotNewConfig();
	void slotFetchDownDone(bool success);
	void slotFetchUpDone(bool);

private:
	KConfig *config;

	KAccel *keyAccel;

	QPopupMenu *fileMenu;
	QPopupMenu *settingsMenu;
	QPopupMenu *helpMenu_;

	QLabel *view;
	Configure *configure;
	LoadDlg *loaddlg;
	SetupDlg *setupdlg;

	bool has_config;
};

#endif // KMLOCFG_H 
