/***************************************************************************
                          ktransferkioimpl.h  -  description
                             -------------------
    begin                : Sun Nov 5 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFERKIOIMPL_H
#define KTRANSFERKIOIMPL_H

//#include <kio/global.h>
#include <kio/job.h>
#include "ktransferimpl.h"

/**
  *@author Sergio Moretti
  */

class KTransferKioImpl : public KTransferImpl  {

  Q_OBJECT
  
  friend class KTransferKio;
  friend class KObject;

public: 
  /** get the temporary file */
  virtual KURL getTempFile(const KURL &rmt, const KURL &lcl) const;
  virtual bool isRunning() const;
  virtual bool isProtocolSupported(const QString &proto) const;

protected:
  /** create empty transfer */
  KTransferKioImpl(int type);
  /** clone operation */
  virtual KObjectImpl* clone() const;

  //virtual void loadData();
  //virtual void updateConf();

  const KTransferKioImpl * global() const;
  void startJob();

  // define abstract methods
  virtual bool processStart();
  virtual bool processKill();
  //virtual bool processCheckResume();

protected slots:
  void slotResult(KIO::Job*);
  //void slotConnected(KIO::Job*);
  void slotTotalSize(KIO::Job*, unsigned long size);
  void slotProcessedSize(KIO::Job*, unsigned long size);
  void slotInfoMessage(KIO::Job*, const QString &msg);
  virtual void slotRetryTimeout();

private:
  KIO::Job *_job;
  bool _startDownload;
  QTimer _waitRetry;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
