/***************************************************************************
                          ktransfer.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.15 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktransferimpl.h"
#include "ktmanager.h"
#include "ktransfer.h"


const KURL & KTransfer::local() const {
  return impl()->local();
}

void KTransfer::setLocal(const KURL &lcl) {
  impl()->setLocal(lcl);
}

void KTransfer::setLocal(const QString &lcl) {
  KURL tmp;
  tmp.setPath(lcl);
  impl()->setLocal(tmp);
}

const KURL & KTransfer::remote() const {
  return impl()->remote();
}

void KTransfer::setRemote(const KURL &rmt) {
  impl()->setRemote(rmt);
}

int KTransfer::len() const {
  return impl()->len();
}

int KTransfer::partial() const {
  return impl()->partial();
}

int KTransfer::resumed() const {
  return impl()->resumed();
}

void KTransfer::setResumed(int r) {
  impl()->setResumed(r);
}

int KTransfer::retry() const {
  return impl()->retry();
}

Status KTransfer::status() const {
  return impl()->status();
}

CommandStatus KTransfer::cmdStatus() const {
  return impl()->cmdStatus();
}

ResumeStatus KTransfer::rsmStatus() const {
  return impl()->rsmStatus();
}

int KTransfer::priority() const {
  return impl()->priority();
}

void KTransfer::setPriority(int p) {
  impl()->setPriority(p);
}

int KTransfer::bandwidth() const {
  return impl()->bandwidth();
}

int KTransfer::mediumBandwidth() const {
  return impl()->mediumBandwidth();
}

QTime KTransfer::startTime() const {
  return impl()->startTime();
}

QString KTransfer::filStatusStr() const {
  return impl()->filStatusStr();
}

QString KTransfer::cmdStatusStr() const {
  return impl()->cmdStatusStr();
}

QString KTransfer::statusStr() const {
  return impl()->statusStr();
}

QString KTransfer::rsmStatusStr() const {
  return impl()->rsmStatusStr();
}

QString KTransfer::fatalErrorLog() const {
  return impl()->fatalErrorLog();
}

void KTransfer::checkResumeCapability() {
  impl()->checkResumeCapability();
}

bool KTransfer::isProtocolSupported(const QString &proto) const {
  return impl()->isProtocolSupported(proto);
}

bool KTransfer::isComplete() const {
  return impl()->isComplete();
}

bool KTransfer::isRunnable(bool automatic) {
  return impl()->isRunnable(automatic);
}

bool KTransfer::isResumable() const {
  return impl()->isResumable();
}

bool KTransfer::isRunning() const {
  return impl()->isRunning();
}

QTime KTransfer::estTime() const {
  return impl()->estTime();
}

KURL KTransfer::getTmpFile() const {
  return impl()->getTmpFile();
}

KURL KTransfer::getTempFile(const KURL &rmt, 
			    const KURL &lcl) const {
  return impl()->getTempFile(rmt, lcl);
}

void KTransfer::start() {
  impl()->start();
}

void KTransfer::kill() {
  impl()->kill();
}

  // CONFIG
  
bool KTransfer::getCheckResume() const {
  return impl()->getCheckResume();
}

void KTransfer::setCheckResume(bool c) {
  impl()->setCheckResume(c);
}

int KTransfer::getMaxResume() const {
  return impl()->getMaxResume();
}

void KTransfer::setMaxResume(int r) {
  impl()->setMaxResume(r);
}

bool KTransfer::getAutoResume() const {
  return impl()->getAutoResume();
}

void KTransfer::setAutoResume(bool m) {
  impl()->setAutoResume(m);
}

int KTransfer::getWaitResume() const {
  return impl()->getWaitResume();
}

void KTransfer::setWaitResume(int w) {
  impl()->setWaitResume(w);
}

int KTransfer::getMaxRetry() const {
  return impl()->getMaxRetry();
}

void KTransfer::setMaxRetry(int m) {
  impl()->setMaxRetry(m);
}

int KTransfer::getWaitRetry() const {
  return impl()->getWaitRetry();
}

void KTransfer::setWaitRetry(int w) {
  impl()->setWaitRetry(w);
}

int KTransfer::getBandSampleTime() const {
  return impl()->getBandSampleTime();
}

void KTransfer::setBandSampleTime(int t) {
  impl()->setBandSampleTime(t);
}

int KTransfer::getReadNotifyTime() const {
  return impl()->getReadNotifyTime();
}

void KTransfer::setReadNotifyTime(int t) {
  impl()->setReadNotifyTime(t);
}

int KTransfer::getPriorityPolicy() const {
  return impl()->getPriorityPolicy();
}

void KTransfer::setPriorityPolicy(int p) {
  impl()->setPriorityPolicy(p);
}

bool KTransfer::getLogProcess() const {
  return impl()->getLogProcess();
}

void KTransfer::setLogProcess(bool l) {
  impl()->setLogProcess(l);
}

const char * KTransfer::docId() { 
  return KTransferImpl::DOCID; 
}

const char * KTransfer::docType() {
  return KTransferImpl::DOCTYPE;
}

const char * KTransfer::mimeType(int i) { 
  return KTransferImpl::MIMETYPE[i]; 
}

KTransfer::KTransfer(KTransferImpl * impl) : KObject(impl) {
}

KTransferImpl * KTransfer::impl() const {
  return dynamic_cast<KTransferImpl*>(KObject::impl());
}
