/***************************************************************************
                          kmagoview.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.16 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <typeinfo>

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>

// application specific includes
#include <kiconloader.h>
#include <kdebug.h>
#include "utils.h"
#include "kmagoview.h"
#include "kmagodoc.h"
#include "ktmanagerdrag.h"
#include "ktransferdrag.h"
#include "kmago.h"


ManagerView::ManagerView(QWidget *parent, const char *name)
  : KListBox(parent, name) {
  setAcceptDrops(true);
  dragState = false;
  connect(this, SIGNAL(rightButtonPressed(QListBoxItem*, const QPoint&)),
	  this, SLOT(slotRightButtonPressed(QListBoxItem*, const QPoint&)));
}

void ManagerView::dragEnterEvent(QDragEnterEvent *event) {
  //kdDebug(D_RUN) << name() << ": drag enter" << endl;
  if (event->source() == this)
    event->accept(false);
  /*
  event->acceptAction(event->source() != this 
		      && (KTransferManager::DragObj::canDecode(event)
			  || QUriDrag::canDecode(event)));
  */			  
}
/* 
void ManagerView::dragLeaveEvent(QDragLeaveEvent *) {
  kdDebug() << name() << ": drag leave" << endl;
}
*/
void ManagerView::dragMoveEvent(QDragMoveEvent *event) {
  //KMagoView *view = dynamic_cast<KMagoView*>(parent());
  ManagerItem * mi = dynamic_cast<ManagerItem*>(itemAt(event->pos()));
  if (event->source() == this) {
    event->accept(false);
  } else {
    /*
    kdDebug(D_RUN) << "MANAGERVIEW: MOVE " 
		   << ",MNGR=" << KTManagerDrag::canDecode(event) 
		   << ",MI=" << (mi != 0 )
		   << ",TRNS=" << KTransferDrag::canDecode(event) 
		   << ",URI=" << QUriDrag::canDecode(event) 
		   << endl;
    */
    if (KTManagerDrag::canDecode(event) 
	|| (mi != 0 && (KTransferDrag::canDecode(event) 
			   || QUriDrag::canDecode(event)))) {
      //kdDebug(D_RUN) << name() << ":DROP ACCEPT" << endl;
      if (event->source() != 0)
	event->acceptAction();
      else
	event->accept();
    } else {
      event->accept(false);
    }
  }
}

void ManagerView::dropEvent(QDropEvent *event) {
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  QStringList uris;
  QString text;
  if (KTManagerDrag::canDecode(event)) {
    kdDebug(D_RUN) << name() << ": drop manager " << (event->source() != this) << endl;
    QDomDocument dom(KTManager::docId());
    if (event->source() != this 
	&& KTManagerDrag::decode(event, dom)) {
      if (event->source() != 0)
	event->acceptAction();
      else
	event->accept();
      kdDebug(D_RUN) << name() << ": drop action " << event->action() << endl;
      //kdDebug(D_RUN) << name() << ": DOC #" << dom.toString() << "#" << endl;
      KTManager m = (view->getDocument()->manager().itemCopy(dom.documentElement())).toTManager();
      if (event->action() == QDropEvent::Move) {
	ManagerView * mv = dynamic_cast<ManagerView*>(event->source());
	ManagerItem *mi = dynamic_cast<ManagerItem*>(mv->item(mv->currentItem()));
	m = mi->manager();
	kdDebug(D_RUN) << name() << ": remove " << m.name() << endl;
	m.container().itemRemove(m);
      }
      //dynamic_cast<KMagoView*>(mv->parent())->mainView()->resetView();
      //view->mainView()->resetView();
      view->reset();
    } else 
      event->acceptAction(false);
  } else {
    ManagerItem * mi = dynamic_cast<ManagerItem*>(itemAt(event->pos()));
    if (mi == 0) {
      event->accept(false);
      return;
    }
    KTManager m = mi->manager();
    if (KTransferDrag::canDecode(event)) {
      kdDebug(D_RUN) << name() << ": drop transfer " << endl;
      QDomDocument dom(KTransfer::docId());
      //FIXME controlla che non muova transfer nello stesso tmanager
      if (!KTransferDrag::decode(event, dom)) {
	kdWarning(D_RUN) << name() << ": error decoding transfer" << endl;
	return;
      }
      if (event->source() != 0)
	event->acceptAction();
      else
	event->accept();
      kdDebug(D_RUN) << name() << ": DOC #" << dom.toString() << "#" << endl;
      KTransfer t = (m.itemCopy(dom.documentElement())).toTransfer();
      kdDebug(D_RUN) << name() << ": create " << t.name() << endl;
      if (event->action() == QDropEvent::Move && event->source() != 0) {
	QListViewItem *ti = 
	  dynamic_cast<TransferView*>(event->source())->selectedItem();
	t = dynamic_cast<TransferItem*>(ti)->transfer();
	kdDebug(D_RUN) << name() << ": remove " << t.name() << endl;
	t.container().itemRemove(t);
      }
    } else if (QUriDrag::canDecode(event)) {
      if (!QUriDrag::decodeToUnicodeUris(event, uris)) {
	kdWarning(D_RUN) << name() << ": error decoding uri" << endl;
	return;
      }
      event->accept();
      //if (event->source() != this && event->action() == QDropEvent::Move)
      kdDebug(D_RUN) << name() << ": URIS=" << uris.join(",") << endl;
      view->mainView()->setCurrentManager(m);
      for (QStringList::Iterator i = uris.begin(); i != uris.end(); ++i)
	view->mainView()->addTransfer(*i);
    } else
      event->accept(false);
  }
}

void ManagerView::mouseReleaseEvent(QMouseEvent *event) {
  dragState = false;
  KListBox::mouseReleaseEvent(event);
}

void ManagerView::mouseMoveEvent(QMouseEvent *event) {
  KListBox::mouseMoveEvent(event);
  if (dragState || !(event->state() & (LeftButton | RightButton | MidButton)))
    return;
  kdDebug(D_RUN) << name() << ": new drag" << endl;
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  ManagerItem *mi = dynamic_cast<ManagerItem*>(itemAt(event->pos()));
  if (mi == 0 || view->getDocument()->manager().itemCount() == 1)
    return;
  dragState = true;
  setSelected(mi, true);
  KTManager m = mi->manager();
  if (m.itemActiveCount() > 0)
    return;
  QDragObject *dragObj = new KTManagerDrag(m, this);
  dragObj->setPixmap(DesktopIcon("kmultiple"));
  if (dragObj->drag() && dragObj->target() != 0)
    kdDebug(D_RUN) << name() << ": drag move" << endl;
  //dragObj->dragMove();
  else
    kdDebug(D_RUN) << name() << ": drag copy" << endl;
    //dragObj->dragCopy();
}

void ManagerView::slotRightButtonPressed(QListBoxItem *item, const QPoint &p) {
  //FIXME se left mouse??
  if (item == 0)
    return;
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  view->mainView()->managerMenu()->exec(p);
}

TransferView::TransferView(QWidget *parent, const char *name) 
  : KListView(parent, name) {
  setAcceptDrops(true);
  setDragEnabled(true);
  setDropVisualizer(true);
  setMinimumSize(0,0);
  connect(this, SIGNAL(dropped(QDropEvent*, QListViewItem*)), 
	  this, SLOT(slotDropped(QDropEvent*, QListViewItem*)));
  connect(this, SIGNAL(executed(QListViewItem*)),
	  this, SLOT(slotExecuted(QListViewItem*)));
  connect(this, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)),
	  this, SLOT(slotContextMenu(KListView*, QListViewItem*, const QPoint&)));
}

void TransferView::startDrag() {
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  KTransfer t = view->mainView()->currentTransfer();
  if (t.isNull() || t.isRunning())
    return;
  kdDebug(D_RUN) << name() << ": new drag" << t.name() << endl;
  QDragObject *dragObj = dragObject();
  dragObj->setPixmap(DesktopIcon("document"));
  if (dragObj->drag() && dragObj->target() != 0)
    kdDebug(D_RUN) << name() << ": drag move" << endl;
  else
    kdDebug(D_RUN) << name() << ": drag copy" << endl;
}

QDragObject * TransferView::dragObject() {
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  return new KTransferDrag(view->mainView()->currentTransfer(), this);
} 

bool TransferView::acceptDrag(QDropEvent *event) const {
  bool accept = (static_cast<const QWidget*>(event->source()) != this 
		 && (KTransferDrag::canDecode(event)
		     || QTextDrag::canDecode(event)
		     || QUriDrag::canDecode(event)));
  if (event->source() != 0)
    event->acceptAction(accept);
  else
    event->accept(accept);
  return accept;
}

void TransferView::slotDropped(QDropEvent *event, QListViewItem *) {
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  KTManager m = view->mainView()->currentManager();
  if (KTransferDrag::canDecode(event)) {
    QDomDocument dom(KTransfer::docId());
    if (!KTransferDrag::decode(event, dom)) {
      kdWarning(D_RUN) << name() << ": error decoding transfer" << endl;
      return;
    }
    if (event->source() != 0)
      event->acceptAction();
    kdDebug(D_RUN) << name() << ": drop " << dom.documentElement().attribute("Name") << endl;
    kdDebug(D_RUN) << name() << ": DOC #" << dom.toString() << "#" << endl;
    KTransfer t = (m.itemCopy(dom.documentElement())).toTransfer();
    kdDebug(D_RUN) << name() << ": create " << t.name() << endl;
    if (event->action() == QDropEvent::Move && event->source() != 0) {
      QListViewItem *ti = 
	dynamic_cast<TransferView*>(event->source())->selectedItem();
      t = dynamic_cast<TransferItem*>(ti)->transfer();
      kdDebug(D_RUN) << name() << ": remove " << t.name() << endl;
      t.container().itemRemove(t);
    }
  } else if (QUriDrag::canDecode(event)) {
    QStringList uris;
    if (!QUriDrag::decodeToUnicodeUris(event, uris)) {
      kdWarning(D_RUN) << name() << ": error decoding URI" << endl;
      return;
    }      
    //if (event->source() != this && event->action() == QDropEvent::Move)
    kdDebug(D_RUN) << name() << ": URIS=" << uris.join(",") << endl;
    for (QStringList::Iterator i = uris.begin(); i != uris.end(); ++i)
      view->mainView()->addTransfer(*i);
  } else if (QTextDrag::canDecode(event)) {
    QString text;
    if (!QTextDrag::decode(event, text)) {
      kdWarning(D_RUN) << name() << ": error decoding text" << endl;
      return;
    }            
    kdDebug(D_RUN) << name() << ": TEXT=" << text << endl;
    view->mainView()->addTransfer(text);
  }
}

void TransferView::slotExecuted(QListViewItem *) {
  //KTransfer *t = dynamic_cast<TransferItem*>(item)->transfer();
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  view->mainView()->slotTransferStatus();
}  
  
void TransferView::slotContextMenu(KListView *, QListViewItem *i, 
				   const QPoint &p) {
  if (i == 0)
    return;
  KMagoView *view = dynamic_cast<KMagoView*>(parent());
  kdFatal(dynamic_cast<TransferItem*>(i)->transfer() != view->mainView()->currentTransfer()) << name() << " context menu" << endl;
  view->mainView()->transferMenu()->exec(p);
}

ManagerItem::ManagerItem(KTManager mngr, KListBox *parent, const QString &text)
  : QListBoxText(parent, text) {
  m = mngr;
  //update();
}

TransferItem::TransferItem(KListView *parent, KTransfer tr)
  : QListViewItem(parent) { 
  t = tr; 
  update();
}

QString TransferItem::text(int column) const {
  switch (column) {
    //#ifndef NTEST
    //  case 0: return QString("%1").arg(t.status(), 5, 16);
    //#else
  case 0: return t.statusStr();
    //#endif
  case 1: 
    return t.remote().prettyURL();
  case 2: 
    return t.local().fileName();
  case 3: 
    return QString("%1:%2").arg(t.rsmStatusStr()).arg(t.resumed());
  case 4: 
    return QString("%1").arg(t.len() ? 100*t.partial()/t.len() : 0, 3);
  case 5: 
    return t.estTime().toString();
  case 6: 
    return unit(t.partial());
  case 7: 
    return unit(t.len());
  case 8: 
    return unit(t.bandwidth());
  case 9: 
    return unit(t.mediumBandwidth());
  case 10: 
    return QString("%1").arg(t.priority(), 3);
  case 11: 
    return QString("%1").arg(t.id(), 5);
  }
  kdFatal(D_VIE) << "TRANSFER COLUMN UNKNOWN" << endl;
  return "";
}

QString TransferItem::key(int column, bool) const {
  switch (column) {
  case 0:
  case 1: 
  case 2: 
  case 3: 
  case 4: 
  case 5: 
    return text(column);
  case 6: 
    return QString("%1").arg(t.partial(), 15);
  case 7: 
    return QString("%1").arg(t.len(), 15);
  case 8: 
    return QString("%1").arg(t.bandwidth(), 15);
  case 9: 
    return QString("%1").arg(t.mediumBandwidth(), 15);
  case 10: 
    return QString("%1").arg(t.priority(), 15);
  case 11: 
    return QString("%1").arg(t.id(), 15);
  }
  kdFatal(D_VIE) << "TRANSFER COLUMN UNKNOWN" << endl;
  return "";
}

void TransferItem::update() {
  if (t.isComplete()) {
    setPixmap(0, SmallIcon("player_eject"));
    return;
  }
  switch (t.status()) {
  case TRN_READY:
  case TRN_FINISH:
    switch (t.cmdStatus()) {
    case CMD_RUNNABLE:
      setPixmap(0, SmallIcon("run"));
      break;
    case CMD_EXITED:
      setPixmap(0, SmallIcon("player_pause"));
      break;
    case CMD_KILLED:
      setPixmap(0, SmallIcon("player_stop"));
      break;
    case CMD_FATALERROR:
      setPixmap(0, SmallIcon("stop"));
      break;
    case CMD_RUNNING:
      ;// unreached
    }
    break;
  case TRN_START:
      setPixmap(0, SmallIcon("connect_no"));
      break;
  case TRN_CONNECT:
      setPixmap(0, SmallIcon("connect_creating"));
      break;
  case TRN_DOWNLOAD:
      setPixmap(0, SmallIcon("connect_established"));
      break;
  }
}

KMagoView::KMagoView(QWidget *parent, const char *name) 
  : QSplitter(parent, name) {
  _lbManager = new ManagerView(this, QString("%1-managerview").arg(name));
  _lvTransfer = new TransferView(this, QString("%1-transferview").arg(name));
  setResizeMode(_lbManager, Stretch);
  setResizeMode(_lvTransfer, Stretch);
  initListView();
  initListBox();
  //_lvTransfer->setMinimumSize(200, 100);
  //setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred));
  //readConfig();
}

void KMagoView::initListView() {
  _lvTransfer->addColumn("Status");
  _lvTransfer->addColumn("URL", 150);
  _lvTransfer->addColumn("Local Filename", 150);
  _lvTransfer->addColumn("Resuming");
  _lvTransfer->addColumn("%");
  _lvTransfer->addColumn("Est.Time");
  _lvTransfer->addColumn("Partial");
  _lvTransfer->addColumn("Len");
  _lvTransfer->addColumn("Band");
  _lvTransfer->addColumn("MBand");
  _lvTransfer->addColumn("Priority");
  _lvTransfer->addColumn("ID");
  _lvTransfer->setSorting(11);
  _lvTransfer->setAllColumnsShowFocus(true);
  _lvTransfer->setShowSortIndicator(true);
  connect(_lvTransfer, SIGNAL(selectionChanged(QListViewItem*)), 
	  this, SLOT(slotSetCurrentTransfer(QListViewItem *)));
}

void KMagoView::initListBox() {
  connect(_lbManager, SIGNAL(selectionChanged(QListBoxItem*)), 
	  this, SLOT(slotSetCurrentManager(QListBoxItem *)));
}

KMagoView::~KMagoView() {
  //writeConfig();
}

KMagoApp * KMagoView::mainView() const {
  KMagoApp *theApp=dynamic_cast<KMagoApp *>(parentWidget());
  return theApp;
}

KMagoDoc * KMagoView::getDocument() const {
  KMagoApp *theApp=(KMagoApp *) parentWidget();
  return theApp->getDocument();
}

void KMagoView::print(QPrinter *pPrinter) {
  QPainter printpainter;
  printpainter.begin(pPrinter);
  
  // TODO: add your printing code here
  
  printpainter.end();
}

/** find manager item */
ManagerItem * KMagoView::findManager(KTManager m) const {
  kdFatal(m.isNull(), D_VIE) << name() << ": FIND MANAGER NULL" << endl;
  ManagerItem *i;
  for (i = dynamic_cast<ManagerItem*>(_lbManager->firstItem()); 
       i != 0 && i->manager() != m; 
       i = dynamic_cast<ManagerItem*>(i->next()));
  kdFatal(i == 0, D_VIE) << name() << ": MANAGER ITEM NOT FOUND" << endl;
  return i;
}

/** add a manager to the view */
void KMagoView::addManager(KTManager m) {
  new ManagerItem(m, _lbManager, m.title());
}

/** remove a transfer from view */
void KMagoView::removeManager(KTManager m){
  kdFatal(m.isNull(), D_VIE) << name() << ": REMOVE MANAGER ITEM NULL" << endl;
  delete findManager(m);
}

/** change the item highlighted in response to a change in the current item */
void KMagoView::selectManager(KTManager m) {
  if (!m.isNull()) {
    _lbManager->setSelected(findManager(m), true);
    resetManager(m);
  } else {
    _lbManager->clearSelection();
    _lvTransfer->clear();
  }
}

/** reset manager view */
void KMagoView::resetManager(KTManager m) {
  kdDebug(D_VIE) << name() << ": reset view manager " << m.id() << endl;
  _lvTransfer->clear();
  for (KTransfer t = (m.itemFirst()).toTransfer(); !t.isNull(); 
       t = (m.itemNext()).toTransfer())
    new TransferItem(_lvTransfer, t);
}

/** find transfer item */
TransferItem * KMagoView::findTransfer(KTransfer t) const {
  kdFatal(t.isNull(), D_VIE) << name() << ": FIND TRANSFER NULL" << endl;
  TransferItem *i;
  for (i = dynamic_cast<TransferItem*>(_lvTransfer->firstChild());
       i != 0 && i->transfer() != t; 
       i = dynamic_cast<TransferItem*>(i->nextSibling()));
  kdError(i == 0, D_VIE) << name() << ": TRANSFER: " << t.id() <<" ITEM NOT FOUND" << endl;
  return i;
}

/** add a transfer to the view */
void KMagoView::addTransfer(KTransfer t) {
  new TransferItem(_lvTransfer, t);
}

/** remove a transfer from view */
void KMagoView::removeTransfer(KTransfer t){
  kdFatal(t.isNull(), D_VIE) << name() << ": REMOVE TRANSFER NULL" << endl;
  delete findTransfer(t);
}

/** change the item highlighted in response to a change in current transfer */
void KMagoView::selectTransfer(KTransfer t) {
  if (!t.isNull())
    _lvTransfer->setSelected(findTransfer(t), true);
  else
    _lvTransfer->clearSelection();
}

/** update the visualization of the item */
void KMagoView::updateTransferText(KTransfer t){
  TransferItem *i = findTransfer(t);
  if (i)
    i->repaint();
}

/** update the visualization of the item */
void KMagoView::updateTransfer(KTransfer t) {
  TransferItem *i = findTransfer(t);
  if (i) 
    i->update();
}

/** reset view */
void KMagoView::reset() {
  kdDebug(D_VIE) << name() << ": reset view" << endl;
  _lbManager->clear();
  _lvTransfer->clear();
  KTManager m;
  for (m = (getDocument()->manager().itemFirst()).toTManager(); !m.isNull(); 
       m = (getDocument()->manager().itemNext()).toTManager()) {
    kdDebug(D_VIE) << name() << ": view manager " << m.id() << ": " 
			<< m.title() << endl;
    new ManagerItem(m, _lbManager, m.title());
  }
  if (!(m = mainView()->currentManager()).isNull())
    resetManager(m);
}

/** show/hide managers listbox */
void KMagoView::showManagers(bool on) { 
  //bool state = _lbManager->isVisible();
  //if (state == on)
  //  return;
  if (on) 
    _lbManager->show(); 
  else 
    _lbManager->hide();
}

/** set split orientation */
void KMagoView::setOrientation(bool vert) {
  bool state = (orientation() == Vertical);
  if (vert == state)
    return;
  if (vert) {
    QSplitter::setOrientation(Vertical);
    _lbManager->setColumnMode(QListBox::FitToWidth);
  }  else {
    QSplitter::setOrientation(Horizontal);
    _lbManager->setColumnMode(1);
  }
}

// Slots

/** change the current item in response to a change in the item highlighted */
void KMagoView::slotSetCurrentManager(QListBoxItem *i) {
  if (i == 0)
    return;
  ManagerItem *item = dynamic_cast<ManagerItem*>(i);
  kdDebug(D_VIE) << name() << ": highlight manager " << item->manager().id() << endl;
  resetManager(item->manager());
  mainView()->setCurrentManager(item->manager());
}

/** change the current item in response to a change in the item highlighted */
void KMagoView::slotSetCurrentTransfer(QListViewItem *i) {
  if (i == 0)
    return;
  TransferItem *item = dynamic_cast<TransferItem*>(i);
  kdDebug(D_VIE) << name() << ": highlight transfer " << item->transfer().id() << endl;
  mainView()->setCurrentTransfer(item->transfer());
}

#include "kmagoview.moc"
