/***************************************************************************
                          kmagodoc.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
//#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>
#include <qmultilineedit.h>
#include <qtextstream.h>

// include files for KDE
#include <kapp.h>
//#include <kurl.h>
#include <kdebug.h>
#include <klocale.h>
// application specific includes
#include "utils.h"
#include "kmago.h"
#include "kmagodoc.h"


KMagoBugReport::KMagoBugReport(QWidget * parent, bool modal, 
			       const KAboutData *aboutData) 
  : KBugReport(parent, modal, aboutData) {
}

void KMagoBugReport::appendLine(const QString &line) {
  m_lineedit->insertLine(line);
}


void KMagoDoc::NotifyChange::operator()(const KObject source,
					ModType type) const {
  _doc->notifyChange(source, type);
}

KMagoDoc::KMagoDoc(QWidget *parent, const char *name) : QObject(parent, name) {
  _title = "Untitled";
  KObject::initFactory();
  connectToMain();
}

KMagoDoc::~KMagoDoc() {
  kdDebug(D_INI) << name() << " destroy" << endl;
  if (!isClosed())
    close();
  //delete KFactoryImpl::factory();
}

/** get the main view */
KMagoApp * KMagoDoc::mainView() const {
  //FIXME come posso fare per togliere la dipendenza da kmagoapp??
  return dynamic_cast<KMagoApp*>(parent());
}

void KMagoDoc::connectToMain() {
  KMagoApp *main = mainView();
  connect(this, SIGNAL(sigMManagerChange()), 
	  main, SLOT(slotDocMManagerChange()));

  connect(this, SIGNAL(sigTManagerAdd(KTManager)), 
	  main, SLOT(slotDocTManagerAdd(KTManager)));
  connect(this, SIGNAL(sigTManagerRemove(KTManager)), 
	  main, SLOT(slotDocTManagerRemove(KTManager)));
  connect(this, SIGNAL(sigTManagerStateChange(KTManager)), 
	  main, SLOT(slotDocTManagerStateChange(KTManager)));
  connect(this, SIGNAL(sigTManagerConfChange(KTManager)), 
	  main, SLOT(slotDocTManagerStateChange(KTManager)));

  connect(this, SIGNAL(sigTransferAdd(KTransfer)), 
	  main, SLOT(slotDocTransferAdd(KTransfer)));
  connect(this, SIGNAL(sigTransferRemove(KTransfer)), 
	  main, SLOT(slotDocTransferRemove(KTransfer)));
  connect(this, SIGNAL(sigTransferStateChange(KTransfer)), 
	  main, SLOT(slotDocTransferStateChange(KTransfer)));
  connect(this, SIGNAL(sigTransferConfChange(KTransfer)), 
	  main, SLOT(slotDocTransferConfChange(KTransfer)));
  connect(this, SIGNAL(sigTransferReadData(KTransfer)),
	  main, SLOT(slotDocTransferReadData(KTransfer)));
}

void KMagoDoc::notifyChange(KObject source, ModType type) {
  //kdDebug(D_RUN) << name() << ": notify " << source.name() << " " << type << endl;
  int type_t = source.type() & TYP_OBJECT_T;
  switch (type_t) {
  case TYP_MMANAGER_T:
    switch (type) {
    case MOD_VIEW:
      emit sigMManagerChange();
      source.setModified(MOD_VIEW, PRP_NONE, false);
      break;
    case MOD_STATE:
      emit sigMManagerChange();
      break;
    default:
      kdFatal(D_RUN) << name() << " UNKNOWN MMANAGER SIGNAL " << type << endl;
    }
    break;
  case TYP_TMANAGER_T:
    switch (type) {
    case MOD_VIEW:
      emit sigTManagerStateChange(source.toTManager());
      source.setModified(MOD_VIEW, PRP_NONE, false);
      break;
    case MOD_ALL:
    case MOD_STATE:
      emit sigTManagerStateChange(source.toTManager());
      break;
    case MOD_CONF:
      emit sigTManagerConfChange(source.toTManager());
      break;
    case MOD_ADD:
      emit sigTManagerAdd(source.toTManager());
      break;
    case MOD_REMOVE:
      emit sigTManagerRemove(source.toTManager());
      break;
    default:
      kdFatal(D_RUN) << name() << "UNKNOWN TMANAGER SIGNAL " << type << endl;
    }
    break;
  case TYP_TRANSFER_T:
    switch (type) {
    case MOD_VIEW:
      emit sigTransferStateChange(source.toTransfer());
      source.setModified(MOD_VIEW, PRP_NONE, false);
      break;
    case MOD_ALL:
    case MOD_STATE:
      emit sigTransferStateChange(source.toTransfer());
      break;
    case MOD_CONF:
      emit sigTransferConfChange(source.toTransfer());
      break;
    case MOD_ADD:
      emit sigTransferAdd(source.toTransfer());
      break;
    case MOD_REMOVE:
      emit sigTransferRemove(source.toTransfer());
      break;
    case MOD_READ:
      emit sigTransferReadData(source.toTransfer());
      break;
    case MOD_ERR: 
      {
	// fatal error, open and compile bug report
	kdDebug(D_RUN) << name() << " catch fatal error of " << source.name() << endl;
	KTransfer t = source.toTransfer();
	KMagoBugReport *bugrep = 
	  new KMagoBugReport(mainView(), true, kapp->aboutData());
	bugrep->appendLine(t.fatalErrorLog());
	bugrep->show();
      }
      break;
    default:
      kdFatal(D_RUN) << "UNKNOWN TRANSFER SIGNAL " << type << endl;
    }
    break;
  default:
    kdFatal(D_RUN) << "UNKNOWN SOURCE TYPE " << type_t << endl;
  }
}

bool KMagoDoc::openNew() {
  QString filename = tempFile();
  kdDebug(D_INI) << name() << ": new " << filename << endl;
  if (!open(filename))
    return false;
  setTitle(i18n("Temporary"));
  return true;
}  

bool KMagoDoc::open(const QString &filename) {
  kdDebug(D_INI) << name() << ": open " << filename << endl;
  kdFatal(!isClosed()) << name() << ": document not closed" << endl;
  _manager = KMManager::managerLoad(filename, true, new NotifyChange(this));
  if (manager().isNull())
    return false;
  setTitle(QFileInfo(filename).fileName());
  if (manager().isEmpty())
    manager().itemNew(i18n("default"));
  return true;
}

/** save document, if filename != "" then save in the current file,
 *  and then copy the data to the new file */
bool KMagoDoc::saveAs(const QString &f) {
  QFileInfo fileInfo(f);
  QString filename = fileInfo.absFilePath();
  if (filename.isEmpty() || filename == manager().fileName())
    return false;
  //QFile f(fileInfo.absFilePath());
  if (manager().save(filename)) {
    setTitle(fileInfo.fileName());
    return true;
  }
  return false;
}

void KMagoDoc::close() {
  if (manager().isModified(MOD_ALL))
    manager().update();
  if (manager().needSaving()) 
    manager().save();
  _manager.deleteInstance();
  _title = "Untitled";
}  

int KMagoDoc::isDuplicate(const KURL &rmt, const KURL &lcl) {
  for(KObject o = manager().itemFirst(); !o.isNull(); o = manager().itemNext()) {
    KTManager m = o.toTManager();
    for (KObject p = m.itemFirst(); !p.isNull(); p = m.itemNext()) {
      KTransfer t = p.toTransfer();
      if (t.remote() == rmt)
	return 1;
      if (t.local() == lcl)
	return 2;
    }
  }
  return 0;
} 

//////////////////////////////////////////////////////////////////
// slots

/** slot to connect to a timer signal to update state saved */
void KMagoDoc::slotUpdate(){
  if (isClosed())
    return;
  manager().runPeriodically();
}

#include "kmagodoc.moc"
