/***************************************************************************
                          kdlgtransfer1.cpp  -  description
                             -------------------
    begin                : Wed Sep 6 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision						 : $Revision: 1.8 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qdir.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qfileinfo.h>
#include <kfiledialog.h>
#include "kdlgtransfer1.h"

KDlgTransfer1::KDlgTransfer1(KTransfer tr, QWidget *parent, const char *name) 
  : QWidget(parent,name){
  t = tr;
  initDialog();
  init();
}

KDlgTransfer1::~KDlgTransfer1(){
}

/** init dialog state */
void KDlgTransfer1::init(){
  lneTBand->setText(QString::number(t.getBandSampleTime()));
  lneTRead->setText(QString::number(t.getReadNotifyTime()));
  lneMaxResume->setText(QString::number(t.getMaxResume()));
  lneResumeTO->setText(QString::number(t.getWaitResume()));
  cmbPriority->setCurrentItem(t.getPriorityPolicy());
  cbtGlobal->setChecked(t.isGlobal());
  cbtCheckResume->setChecked(t.getCheckResume());
  cbtAutoResume->setChecked(t.getAutoResume());
  slotSetGlobal(t.isGlobal());
  cbtGlobal->setEnabled(t.id() != 0L);
  lneMaxRetry->setText(QString::number(t.getMaxRetry()));
  lneRetryTO->setText(QString::number(t.getWaitRetry()));
  cbtLog->setChecked(t.getLogProcess());
  connect(cbtGlobal, SIGNAL(toggled(bool)), this, SLOT(slotSetGlobal(bool)));
}

void  KDlgTransfer1::initDialog(){

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
  l->addWidget(gbox);

  cbtGlobal= new QCheckBox(i18n("Use global settings"), gbox, "CbtGlobal");

  QHBox *box = new QHBox(gbox);
  QLabel *lbl = new QLabel(i18n("Bandwidth sample time (ms)"), box, "LblTBand");
  lneTBand = new QLineEdit(box, "LneTBand");
  lneTBand->setFixedWidth(lneTBand->fontMetrics().width("XXXXXXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneTBand, 0);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Display update interval (ms)"), box, "LblTRead");
  lneTRead= new QLineEdit(box, "LneTRead");
  lneTRead->setFixedWidth(lneTRead->fontMetrics().width("XXXXXXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneTRead, 0);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Priority Policy"), box, "LblPrPol");
  cmbPriority= new KComboBox(box, "cmbPriority");
  cmbPriority->insertItem(i18n("FIFO"));
  cmbPriority->insertItem(i18n("LIFO"));
  cmbPriority->insertItem(i18n("Short First"));
  cmbPriority->insertItem(i18n("Long First"));
  cmbPriority->insertItem(i18n("User Defined"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(cmbPriority, 0);

  cbtLog = new QCheckBox(i18n("Log Process output"), gbox, "CbtLog");

  gbox = new QGroupBox(1, Horizontal, i18n("Resuming"), this, "GB2");
  l->addWidget(gbox);

  cbtAutoResume = 
    new QCheckBox(i18n("Automatically resume interrupted transfers"), 
		  gbox, "CbtAutoResume");

  cbtCheckResume = new QCheckBox(i18n("Check for transfer resume capability"), 
				 gbox, "CbtCheckResume");

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Maximum number of resume retries"), 
		   box, "LblMaxResume");
  lneMaxResume = new QLineEdit(box, "LneMaxResume");
  lneMaxResume->setFixedWidth(lneMaxResume->fontMetrics().width("XXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneMaxResume, 0);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Try to resume after (seconds)"), box, "LblResumeTO");
  lneResumeTO= new QLineEdit(box, "LneResumeTO");
  lneResumeTO->setFixedWidth(lneResumeTO->fontMetrics().width("XXXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneResumeTO, 0);

  gbox = new QGroupBox(1, Horizontal, i18n("Retries"), this, "GB3");
  l->addWidget(gbox);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Maximum number of retries"), box, "LblMaxRetry");
  lneMaxRetry = new QLineEdit(box, "LneMaxRetry");
  lneMaxRetry->setFixedWidth(lneMaxRetry->fontMetrics().width("XXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneMaxRetry, 0);

  box = new QHBox(gbox);
  lbl = new QLabel(i18n("Retry after (seconds)"), box, "LblRetryTO");
  lneRetryTO = new QLineEdit(box, "LneRetryTO");
  lneRetryTO->setFixedWidth(lneRetryTO->fontMetrics().width("XXXXX"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneRetryTO, 0);
}

/**  */
void KDlgTransfer1::accept(){
  t.setMaxResume(QString(lneMaxResume->text()).toInt());
  t.setWaitResume(QString(lneResumeTO->text()).toInt());
  t.setGlobal(cbtGlobal->isChecked());
  t.setCheckResume(cbtCheckResume->isChecked());
  t.setAutoResume(cbtAutoResume->isChecked());
  t.setMaxRetry(QString(lneMaxRetry->text()).toInt());
  t.setWaitRetry(QString(lneRetryTO->text()).toInt());
  t.setBandSampleTime(QString(lneTBand->text()).toInt());
  t.setReadNotifyTime(QString(lneTRead->text()).toInt());
  t.setPriorityPolicy(static_cast<PriorityPolicy>(cmbPriority->currentItem()));
  t.setLogProcess(cbtLog->isChecked());
}

/** check if the dialog is in an acceptable state */
bool KDlgTransfer1::isAcceptable(){
  bool check;
  QString(lneResumeTO->text()).toInt(&check);
  if (!check) return false;
  QString(lneMaxResume->text()).toInt(&check);
  if (!check) return false;
  QString(lneRetryTO->text()).toInt(&check);
  if (!check) return false;
  QString(lneMaxRetry->text()).toInt(&check);
  if (!check) return false;
  QString(lneTRead->text()).toInt(&check);
  if (!check) return false;
  QString(lneTBand->text()).toInt(&check);
  if (!check) return false;
  return true;
}

/** update the dialog after a change in global checkbutton */
void KDlgTransfer1::slotSetGlobal(bool on){
  lneMaxResume->setEnabled(!on);
  lneResumeTO->setEnabled(!on);
  cbtCheckResume->setEnabled(!on);
  cbtAutoResume->setEnabled(!on);
  lneMaxRetry->setEnabled(!on);
  lneRetryTO->setEnabled(!on);
  lneTRead->setEnabled(!on);
  lneTBand->setEnabled(!on);
  cmbPriority->setEnabled(!on);
  cbtLog->setEnabled(!on);
  emit signalGlobalChange(on);
}

#include "kdlgtransfer1.moc"
