/***************************************************************************
                          kdlgtransfer.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include "kdlgtransfer1.h"
#include "kdlgtransferwget1.h"
#include "kdlgtransfer.h"

KDlgTransfer::KDlgTransfer(KTransfer t, QWidget *parent, const char *name ) :
  QTabDialog(parent,name, true) {
  _t = t;
  init();
}

KDlgTransfer::~KDlgTransfer(){
}

/** init dialog state */
void KDlgTransfer::init() {
  resize(340, 380);
  setMinimumSize(340, 380);
	
  setCaption(i18n("Transfer Options"));

  setOkButton();
  setHelpButton();
  setCancelButton();

  _p1 = new KDlgTransfer1(_t, this);
  addTab(_p1, i18n("General"));

  KTransferWget tw = _t.toTransferWget();
  if (!tw.isNull()) {
    _p2w = new KDlgTransferWget1(tw, this);
    connect(_p1, SIGNAL(signalGlobalChange(bool)),
	    _p2w, SLOT(slotSetGlobal(bool)));
    addTab(_p2w, KObject::typeStr(tw.type()));
  }

  connect(this, SIGNAL(defaultButtonPressed()), SLOT(accept()));
  connect(this, SIGNAL(helpButtonPressed()), SLOT(help()));
  connect(this, SIGNAL(cancelButtonPressed()), SLOT(reject()));
}

/**  */
void KDlgTransfer::accept() {
  if (!_p1->isAcceptable()
      || (_p2w && !_p2w->isAcceptable())
      )
    return;
  _p1->accept();
  if (_p2w)
    _p2w->accept();
  _t.setModified(MOD_CONF, PRP_ALL);
  QDialog::accept();
}

#include "kdlgtransfer.moc"
