/***************************************************************************
                          kdlgmanager.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktransferwget.h"
#include "kdlgtransfer1.h"
#include "kdlgtransferwget1.h"
//#include "kmagodoc.h"
#include "kdlgmanager1.h"
#include "kdlgmanager.h"

KDlgManager::KDlgManager(KTManager mngr, QWidget *parent, 
			 const char *name ) : 
  QTabDialog(parent,name, true), m(mngr) {
  init();
}

KDlgManager::~KDlgManager(){
}

/** init dialog state */
void KDlgManager::init() {
  resize(340, 380);
  setMinimumSize(340, 380);
  
  setCaption(i18n("Manager Options"));

  setOkButton();
  setHelpButton();
  setCancelButton();
	
  _p1 = new KDlgManager1(m, this, "KDlgManager1");
  addTab(_p1, i18n("Manager"));
  
  KTransfer t = m.findGlobal(TYP_TWGET);
  _p2 = new KDlgTransfer1(t, this, "KDlgTransfer1-Wget");
  addTab(_p2, i18n("Wget 1"));
  
  _p3 = new 
    KDlgTransferWget1(t.toTransferWget(), this, 
		      "KDlgTransferWget1");
  addTab(_p3, i18n("Wget 2"));
  connect(_p2, SIGNAL(signalGlobalChange(bool)), 
	  _p3, SLOT(slotSetGlobal(bool)));
	
#ifdef ENABLE_KIO
  t = m.findGlobal(TYP_TKIO);
  _p4 = new KDlgTransfer1(t, this, "KDlgTransfer1-Kio");
  addTab(_p4, i18n("Kio"));
#endif

  connect(this, SIGNAL(defaultButtonPressed()), SLOT(accept()));
  connect(this, SIGNAL(helpButtonPressed()), SLOT(help()));
  connect(this, SIGNAL(cancelButtonPressed()), SLOT(reject()));
}

/**  */
void KDlgManager::accept() {
  if (!_p1->isAcceptable()
      || !_p2->isAcceptable() || !_p3->isAcceptable()
#ifdef ENABLE_KIO
      || !_p4->isAcceptable()
#endif
      )
    return;
  _p1->accept();
  _p2->accept();
  _p3->accept();
#ifdef ENABLE_KIO
  _p4->accept();
  m.findGlobal(TYP_TKIO).setModified(MOD_CONF, PRP_THIS);
#endif
  m.findGlobal(TYP_TWGET).setModified(MOD_CONF, PRP_THIS);  
  m.setModified(MOD_ALL, PRP_ALL);
  //_doc->setModified(); //FIXME!! inutile, stato cambiato dai proto
  //_doc->setCurrentTransfer(0); // FIXME!! solo x update bottone autoResume
  m.update();
  QDialog::accept();
}

#include "kdlgmanager.moc"
