/***************************************************************************
                          kdlgapp.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include "kmago.h"
#include "kdlgapp.h"


KDlgApp::KDlgApp(KMagoApp *a, const char *name) : 
  QDialog(a,name,true) {
  _app = a;
  initDialog();
  init();
}

KDlgApp::~KDlgApp(){
}

void KDlgApp::init() {
  setCaption("Application Options");
  cbtAEFile->setChecked(_app->getOpenFlags() & FLG_FILE_AUTO_ENCODE);
  cbtNoPrompt->setChecked(_app->getOpenFlags() & FLG_NO_PROMPT);
  cbtFEFile->setChecked(_app->getOpenFlags() & FLG_FILE_FORCE_ENCODE);
  cbtLoadLast->setChecked(_app->getLoadLastDoc());
  lneUpdateInt->setText(QString().setNum(_app->getUpdateTime()));
  switch (_app->getStartMode()) {
  case START_NOW:
    rbtStart0->setChecked(true);
    break;
  case START_PROMPT:
    rbtStart1->setChecked(true);
    break;
  case START_NO:
    rbtStart2->setChecked(true);
    break;
  }
  cbtExpert->setChecked(_app->getExpertMode());
}

void  KDlgApp::initDialog(){
    
  QBoxLayout * l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, this, "GB1");
  gbox->setTitle(i18n("General"));
  l->addWidget(gbox);

  QHBox * box = new QHBox(gbox);

  QLabel *lbl = new QLabel(box, "LblUpdateInt");
  lbl->setText(i18n("Update interval (seconds)"));
  lneUpdateInt = new QLineEdit(box, "LneUpdateInt");
  lneUpdateInt->setFixedWidth(lneUpdateInt->fontMetrics().width("XXX"));
  QToolTip::add(lneUpdateInt,i18n("Number of seconds between update"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneUpdateInt, 0);

  cbtExpert= new QCheckBox(gbox, "CbtExpert");
  QToolTip::add(cbtExpert,i18n("No confirmation for destructive actions"));
  cbtExpert->setText(i18n("Expert mode: no confirmation prompt"));

  cbtLoadLast = new QCheckBox(gbox,"CbtLoadLast");
  QToolTip::add(cbtLoadLast,i18n("Start up with last used document"));
  cbtLoadLast->setText(i18n("Start up with last used document"));

  gbox = new QGroupBox(1, Horizontal, this, "GB2");
  gbox->setTitle(i18n("Input Validation"));
  l->addWidget(gbox);

  cbtNoPrompt= new QCheckBox(gbox, "CbtNoPrompt");
  QToolTip::add(cbtNoPrompt,
		i18n("Don't prompt for changes in transfer insertion"));
  cbtNoPrompt->setText(i18n("Automatic transfer insertion"));

  cbtAEFile= new QCheckBox(gbox, "CbtAEFile");
  QToolTip::add(cbtAEFile,
		i18n("Automatic encoding of filename when containing spaces"));
  cbtAEFile->setText(i18n("Auto encode filename"));

  cbtFEFile= new QCheckBox(gbox,"CbtFEFile");
  QToolTip::add(cbtFEFile,
		i18n("Force filename encoding when containing spaces"));
  cbtFEFile->setText(i18n("Force filename encoding"));

  QButtonGroup * bg = new QButtonGroup(1, Horizontal, this, "BgrStart");
  bg->setTitle(i18n("Adding Transfer Mode"));
  l->addWidget(bg);

  rbtStart0 = new QRadioButton(bg,"RbtStart0");
  rbtStart0->setText(i18n("Start download immediatly"));

  rbtStart1 = new QRadioButton(bg,"RbtStart1");
  rbtStart1->setText(i18n("Prompt to start or add to list"));

  rbtStart2 = new QRadioButton(bg,"RbtStart2");
  rbtStart2->setText(i18n("Add to list"));
  
  QHBoxLayout *btnBox = new QHBoxLayout(l);
  btnBox->addStretch(1);

  QPushButton *btn = new QPushButton(i18n("OK"), this, "BtnOK");
  btn->setDefault(true);
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(accept()));

  btn = new QPushButton(i18n("Cancel"), this, "BtnCancel");
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(reject()));
}

void KDlgApp::accept() {
  bool check;
  QString(lneUpdateInt->text()).toInt(&check);
  if (!check)
    return;
  int f = ((cbtAEFile->isChecked() ? FLG_FILE_AUTO_ENCODE : 0) 
	   + (cbtFEFile->isChecked() ? FLG_FILE_FORCE_ENCODE : 0)
	   + (cbtNoPrompt->isChecked() ? FLG_NO_PROMPT : 0));
  _app->setOpenFlags(f);
  _app->setUpdateTime(QString(lneUpdateInt->text()).toInt());
  _app->setStartMode(getStartMode());
  _app->setExpertMode(cbtExpert->isChecked());
  _app->setLoadLastDoc(cbtLoadLast->isChecked());
  QDialog::accept();
}

/**  */
int KDlgApp::getStartMode(){
  return (rbtStart0->isChecked() * START_NOW 
	  + rbtStart1->isChecked() * START_PROMPT 
	  + rbtStart2->isChecked() * START_NO);
}

#include "kdlgapp.moc"
