/***************************************************************************
                          rpmtree.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rpmtree.h"

#include "../config.h"
#ifdef HAVE_LIBRPM

#include <iostream.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <kiconloader.h>
#include <klocale.h>
#include "integerdialog.h"

RPMTree::RPMTree(GroupViewWidget * gv) : GroupTree(gv){
	setType(TYPE_RPM);
	KIconLoader l;
	topItem() -> setText(0,"RPM");
	QString s;
	setRPMSafetyLevel(28);
	s.setNum(rpmSafetyLevel());
	topItem() -> setText(6,s);
	topItem() -> setPixmap(0,l.loadIcon("rpm", KIcon::Small));	
}

RPMTree::~RPMTree(){
}

void RPMTree::itemClicked(QListViewItem * i, const QPoint &p, int c){
	if (topItem() -> childCount() == 0 && c != 6){
		setup();
		return;
	}
	if (i != 0){
		if (i == topItem()){
			switch (c){
				case 0:
			    topItem() -> setOpen(!topItem() -> isOpen());
					break;
				case 6:
					listView() -> setCursor(arrowCursor);
					IntegerDialog * d = new IntegerDialog();
					d -> SpinBox1 -> setValue(rpmSafetyLevel());
					int i = d -> exec();
					if (i == 0){
						QString s(d -> SpinBox1 -> text());
						setRPMSafetyLevel(s.toInt());
						topItem() -> setText(6,s);
						deleteTree();
					}
					break;
			}
		}
		if (i -> parent() == topItem()){
			switch (c){
			case 0:
				emit setupFileList(group(name(i)));
				emit setProperties(group(name(i)));
				group(name(i)) -> clearMem();
				break;
			case 1:
				FileGroupBase * g = group(name(i));
				g -> setMarked(!g -> isMarked());
				if (g -> isMarked()){
					KIconLoader l;
					i -> setPixmap(1,QPixmap(l.loadIcon("flag",KIcon::Small)));
				}
				else
					i -> setPixmap(1,QPixmap());
			}
		}
	}
	if (topItem() -> childCount() > 0)
		setupReady();
}

void RPMTree::updateReady(){
	for (unsigned int i = 0; i < groupCount(); i++)
		setupItem(group(i), item(topItem(), group(i) -> name()));
	topItem() -> setOpen(true);
	setupReady();
}

void RPMTree::groupToItem(FileGroupBase * g, QListViewItem * i){
	KIconLoader l;
	i -> setPixmap(0,l.loadIcon("rpm", KIcon::Small));
	i -> setText(6,"");
}

void RPMTree::setup(){
	updateProgress = new ButtonLabelWidget2(0,0,true);
	updateProgress -> setCaption(i18n("Analyzing files..."));
	updateProgress -> TextLabel2 -> setText(i18n("Check system for RPM's..."));
	updateProgress -> show();
	connect(updateProgress -> PushButton1, SIGNAL(clicked()), SLOT(slotCancel()));
	updateProcess = new ABProcess();
	*updateProcess << "rpm";
	*updateProcess << "-qa";
	connect(updateProcess, SIGNAL(processExited(KProcess*)), SLOT(slotRPMQueryEnded()));
	counter = 0;
	updateProcess -> start(KProcess::NotifyOnExit, KProcess::AllOutput);
}

void RPMTree::slotRPMQueryEnded(){
	updateProgress -> ProgressBar1 -> setProgress(0);
	updateProgress -> ProgressBar1 -> setTotalSteps(updateProcess -> output -> count());
	KIconLoader l;
	updateProgress -> TextLabel1 -> setPixmap(l.loadIcon("rpm", KIcon::Small));

	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), SLOT(slotRPM()));
	timer -> start(0);
}

void RPMTree::slotRPM(){
	if (counter == updateProcess -> output -> count()){
		timer -> stop();
		delete updateProcess;
		delete updateProgress;
		updateReady();
	}
	else{
		updateProgress -> ProgressBar1 -> setProgress(counter);
	  updateProgress -> TextLabel2 -> setText(updateProcess -> output -> at(counter));
		_rpm = new RPM(updateProcess -> output -> at(counter),rpmSafetyLevel());
		addGroup(_rpm);
		_rpm -> clearMem();
		counter++;
	}
}

void RPMTree::slotCancel(){
	counter = updateProcess -> output -> count();
}

#else
RPMTree::RPMTree(GroupViewWidget * gv) : GroupTree(gv){}
RPMTree::~RPMTree(){}
void RPMTree::itemClicked(QListViewItem * i, const QPoint &p, int c){}
void RPMTree::updateReady(){}
void RPMTree::groupToItem(FileGroupBase * g, QListViewItem * i){}
void RPMTree::setup(){}
void RPMTree::slotRPMQueryEnded(){}
void RPMTree::slotRPM(){}
void RPMTree::slotCancel(){}
#endif
