/***************************************************************************
                          schedule.cpp  -  description
                             -------------------
    begin                : Sat Aug 12 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          schedule.cpp  -  description
                             -------------------
    begin                : Wed Mar 1 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "schedule.h"

Schedule::Schedule(){
	daylst.clear();
	daylst.setAutoDelete(true);
	hourlst.clear();
	hourlst.setAutoDelete(true);
	minutelst.clear();
	minutelst.setAutoDelete(true);
	setDayCycle(0);
	setHourCycle(0);
	setMinuteCycle(0);	
	timer = new QTimer();
}

Schedule::~Schedule(){
}

void Schedule::start(){
	connect( timer, SIGNAL(timeout()), this, SLOT(slotEvent()) );
	timer->start( 60 * 1000);
}

void Schedule::stop(){
	disconnect( timer, SIGNAL(timeout()), this, SLOT(slotEvent()) );
}

void Schedule::slotEvent(){
	QDateTime dt;
	dt = dt.currentDateTime();
	QTime t = dt.time();
	QDate d = dt.date();
	if (inDayList(d.day()) && inHourList(t.hour()) && inMinuteList(t.minute()))
		emit action();
}

QDateTime Schedule::lastEvent(){
	QDateTime dt;
	dt = dt.currentDateTime();
	QTime t = dt.time();
	QDate d = dt.date();
	while(!(inDayList(d.day()) && inHourList(t.hour()) && inMinuteList(t.minute()))){
		dt = dt.addSecs(-60);
		t = dt.time();
		d = dt.date();
	}
	return dt;
}

bool Schedule::inDayList(int i){
	bool b = false;
	for (unsigned int j = 0; j < dayList().count(); j++){
		if (*dayList().at(j) == i )
			 b = true;
	}
	if (dayCycle() > 0 && i%dayCycle() == 0)
		b = true;
	return b;	
}

bool Schedule::inHourList(int i){
	bool b = false;
	for (unsigned int j = 0; j < hourList().count(); j++){
		if (*hourList().at(j) == i )
			 b = true;
	}
	if (hourCycle() > 0 && i%hourCycle() == 0)
		b = true;
	return b;
}

bool Schedule::inMinuteList(int i){
	bool b = false;
	for (unsigned int j = 0; j < minuteList().count(); j++){
		if (*minuteList().at(j) == i )
			b = true;
	}
	if (minuteCycle() > 0 && i%minuteCycle() == 0)
		b = true;
	return b;
}

void Schedule::addDay(int d){
	if (!inDayList(d)){
		int * i = new int;
		*i = d;
		daylst.append(i);
	}
}

void Schedule::delDay(int d){
	if (inDayList(d))
		for (unsigned int i = 0; i < dayList().count(); i++)
			if (*dayList().at(i) == d )
				daylst.remove(i);
}

void Schedule::addHour(int h){
	if (!inHourList(h)){
		int * i = new int;	
		*i = h;
		hourlst.append(i);
	}
}

void Schedule::delHour(int d){
	if (inHourList(d))
		for (unsigned int i = 0; i < hourList().count(); i++)
			if (*hourList().at(i) == d )
				hourlst.remove(i);
}

void Schedule::addMinute(int m){
	if (!inMinuteList(m)){
		int * i = new int;
		*i = m;
		minutelst.append(i);
	}
}

void Schedule::delMinute(int d){
	if (inMinuteList(d))
		for (unsigned int i = 0; i < minuteList().count(); i++)
			if (*minuteList().at(i) == d )
				minutelst.remove(i);
}

void Schedule::setDayList(QList<int> l){
	clearDayList();
	for (unsigned int i = 0; i < l.count(); i++)
		addDay(*l.at(i));	
}

void Schedule::setHourList(QList<int> l){
	clearHourList();
	for (unsigned int i = 0; i < l.count(); i++)
		addHour(*l.at(i));
}

void Schedule::setMinuteList(QList<int> l){
 clearMinuteList();
 for (unsigned int i = 0; i < l.count(); i++)
 	addMinute(*l.at(i));
}

bool Schedule::isIllegalSchedule(){
	bool b = false;
	if (dayList().count() == 0 & dayCycle() == 0 )
		b = true;
	if (hourList().count() == 0 & hourCycle() == 0)
		b = true;
	if (minuteList().count() == 0 & minuteCycle() == 0)
		b = true;
	return b;
}
