/***************************************************************************
                          ins.cpp  -  description
                             -------------------
    begin                : Sun Nov 12 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ins.h"

#include <qtextstream.h>
#include "info.h"

INS::INS(QString s){
	bfn = s;
	setName(s);
	setType(TYPE_INS);
	setDescription("This group is intalled by invoking 'make install'");
}

INS::~INS(){
}

void INS::loadFiles(){
	unloadFiles();
	QFile f(insDir() + baseFileName() + ".files");
	if (f.open(IO_ReadOnly)){
		QTextStream t(&f);
		QString file;
		while (!t.eof()){
			file = t.readLine();
			addFileFast(file);
			QFileInfo fi(file);
			if (fi.permission(QFileInfo::ExeUser)){ // Do not use isExecutable(), seems bug in qt in case of root
				setName(fi.baseName());
				setIcon(fi.baseName());
			}
		}	
		f.close();
	}
	sync();
}

ABProcess * INS::unInstall(){
	ABProcess * p = new ABProcess("rm");
	*p << "rm";
	*p << "-vf";
	for (unsigned int i = 0; i< numFiles(); i++)
		*p << file(i);
	return p;
}
