/***************************************************************************
                          configuredialog.cpp  -  description
                             -------------------
    begin                : Thu Jan 18 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuredialog.h"
#include <stdlib.h>
#include <iostream.h>

#include <qcheckbox.h>
#include <qlineedit.h>
#include "qfileinfo.h"

#include <kstddirs.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <klocale.h>

ConfigureDialog::ConfigureDialog():ConfigureBase(0,0,true){
	slotInstallPathChanged();
}

ConfigureDialog::~ConfigureDialog(){
}

void ConfigureDialog::accept(){
	if (CheckBox1 -> isChecked()){
		if (!wrapped()){
			QString c ="mv ";
			c += fileName1();
			c += " ";
			c += fileName2();
			if (system(c))
				 KMessageBox::information(0,i18n(QString("An error occured while moving ") + fileName1() + " to " + fileName2()));
			c = "cp ";
			c += KGlobal::dirs() -> findResource("data","kleandisk/install.kleandisk");	
			c += QString(" ") += fileName1();
			if (system(c))
				KMessageBox::information(0,i18n(QString("An error occured while copying ") + fileName1() + " to " + fileName2()));
			c = "chmod a+x ";
			c += fileName1();
			system(c);
		}
	}

	if (!CheckBox1 -> isChecked()){
		if (wrapped()){
			QString c;
			c = "mv ";
			c += fileName2();
			c += " ";
			c += fileName1();
			if (system(c))
				KMessageBox::information(0,i18n(QString("An error occured while moving ") + fileName2() + " to " + fileName1()));
		}
	}
	setResult(0);
	hide();
}

void ConfigureDialog::reject(){
	setResult(1);
	hide();
}

QString ConfigureDialog::fileName1(){
	QString fn = LineEdit5 -> text();
	return fn;
}

QString ConfigureDialog::fileName2(){
	QString fn = fileName1() + ".kd";
	return fn;
}

bool ConfigureDialog::wrapped(){
	bool b = false;
	QFileInfo fi(fileName2());
	if (fi.exists())
		b = true;
	return b;
}
void ConfigureDialog::slotGuessInstallPath(){
	KProcess * p = new KProcess();
	connect(p, SIGNAL(receivedStdout(KProcess *,char *, int))	,SLOT(slotWhichOutput(KProcess *,char *,int )));
	p -> clearArguments();
	*p << "which";
	*p << "install";
	p -> start(KProcess::Block,KProcess::AllOutput);
	delete p;
}

void ConfigureDialog::slotWhichOutput(KProcess *, char * b, int l){
	b[l-1] = '\0';
	LineEdit5 -> setText(b);
}

void ConfigureDialog::slotInstallPathChanged(){
	QString fn1 = LineEdit5 -> text();
	QFileInfo fi(fn1);
	if (fi.exists())
		CheckBox1 -> setEnabled(true);
	else
		CheckBox1 -> setEnabled(false);
	CheckBox1 -> setChecked(wrapped());
}

