/***************************************************************************
                          abicondialog.cpp  -  description
                             -------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstringlist.h>
#include <qfileinfo.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kiconview.h>

#include "abicondialog.h"

ABIconDialog::ABIconDialog() : ABIconBase(0,"", true){
	connect(IconView1,SIGNAL(selectionChanged(QIconViewItem*)), SLOT(slotSelectionChanged(QIconViewItem*)));
	icn = QString::null;
	IconView1 -> setGridX(50);
	IconView1 -> setGridY(40);
	slotActivated("Mime Type");
}
ABIconDialog::~ABIconDialog(){
}

void ABIconDialog::slotActivated(const QString &s){
	KIconLoader l;
	QFileInfo fi;
	QStringList lst;
	if (s == i18n("Mime Type"))
		lst = l.queryIcons(KIcon::Small, KIcon::MimeType);
	if (s == i18n("Action"))
		lst = l.queryIcons(KIcon::Small, KIcon::Action);
	if (s == i18n("Application"))
		lst = l.queryIcons(KIcon::Small, KIcon::Application);
	if (s == i18n("Device"))
		lst = l.queryIcons(KIcon::Small, KIcon::Device);
	if (s == i18n("File System"))
		lst = l.queryIcons(KIcon::Small, KIcon::FileSystem);

	IconView1 -> clear();
	for (unsigned int i = 0; i < lst.count(); i++){
		fi = QFileInfo(*lst.at(i));
		new QIconViewItem(IconView1,	fi.baseName(), *lst.at(i));
	}
}

void ABIconDialog::slotSelectionChanged(QIconViewItem* i){
	icn = i -> text();
	this -> hide();
}

void ABIconDialog::reject(){
	this -> hide();
}
