/***************************************************************************
                          udgdialog.cpp  -  description
                             -------------------
    begin                : Fri Mar 10 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "udgdialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>

UDGDialog::UDGDialog(UDG * g) : QTabDialog(0,i18n("UDG Dialog"), true) {
	u = g;
	udgEditGeneral = new UDGEditGeneral(g,this);
	udgEditCriteria = new UDGEditCriteria(g,this);
	udgEditSettings = new UDGEditSettings(g,this);
	udgEditFiles = new UDGEditFiles(g,this);
	scheduleWidget = new ScheduleWidget(g,this);

	setFixedSize(450,330);
	addTab(udgEditGeneral, i18n("General"));
	addTab(udgEditCriteria, i18n("File Criteria"));
	addTab(udgEditFiles, i18n("Files"));
	addTab(udgEditSettings, i18n("Settings"));
	addTab(scheduleWidget, i18n("Schedule"));
	setCancelButton();
	connect(this,SIGNAL(applyButtonPressed()),SLOT(slotOkClicked()));
	connect(this,SIGNAL(cancelButtonPressed()),SLOT(slotCancelClicked()));
}

UDGDialog::~UDGDialog(){
}

void UDGDialog::slotOkClicked(){
	if (udgEditGeneral -> error()){
		KMessageBox::information(0,udgEditGeneral -> error());
		ret = 1;
		return;
	}
	if (udgEditCriteria -> error()){
		KMessageBox::information(0,udgEditCriteria -> error());
		ret = 1;
		return;
	}
	if (scheduleWidget -> error()){
		KMessageBox::information(0,scheduleWidget -> error());
		ret = 1;
		return;
	}
	udgEditGeneral -> editorToGroup();	
	udgEditCriteria -> editorToGroup();	
	udgEditSettings -> editorToGroup();	
	udgEditFiles -> editorToGroup();
	scheduleWidget -> scheduleToGroup();
	u -> save();
	ret = 0;
}

void UDGDialog::slotCancelClicked(){
	ret = 2;
	delete this;
}
