/***************************************************************************
                          xkeyboard.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XKEYBOARD_H
#define XKEYBOARD_H

#include <qstringlist.h>

#include <X11/Xlib.h>
#include <X11/XKBlib.h>

/**This class incapsulates XKeyboard Extension interface
  *@author Leonid Zeitlin
  */

class XKeyboard {
private:
  int m_event_code;
  int m_numgroups;
  static XKeyboard *m_self;
public:
  XKeyboard();
	~XKeyboard();
  /** Determine if the given XEvent e is an XKB event with type XkbStateNotify.
    * If so, newgroupno will return the new keyboard group # */
  bool isXkbStateNotifyEvent(XEvent *e, int *newgroupno);
  /** Set the current keyboard group to the given groupno */
  void setKbdGroup(int groupno);
  /** Get the names of the currently configured keyboard groups */
  void getGroupNames(QStringList &list);
  static XKeyboard* self();
  /** return the current keyboard group index */
  int getGroupNo();
  int getNumKbdGroups() { return m_numgroups; };
};

#endif
