/***************************************************************************
                          kbswitchtrayicon.cpp  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbswitchtrayicon.h"
#include <kpopupmenu.h>
#include <kstddirs.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kaboutapplication.h>
#include <kapp.h>
#include <kiconloader.h>

KBSwitchTrayIcon::KBSwitchTrayIcon(KBConfig *conf){
  int i;
  QPixmap pix;
  KBGroup *group;

  this->conf = conf;
  QObject::connect(conf, SIGNAL(changed()), this, SLOT(updateIcons()));
  KPopupMenu * menu = contextMenu();
  for (i = 0; i < conf->groupCount(); i++) {
    group = conf->getGroup(i);
    menu->insertItem(group->getPixmap(), group->getName(), i);
  }
  QObject::connect(menu, SIGNAL(activated(int)), this, SLOT(slotMenuActivated(int)));

  menu->insertSeparator();
  KAction *pref = KStdAction::preferences(this, SIGNAL(preferencesSelected()), this);
  pref->plug(menu);
  KAction *about = KStdAction::aboutApp(this, SLOT(slotAbout()), this);
  about->plug(menu);

  /*QString path = locate("icon", "hicolor/16x16/apps/locale.png");
  if (!path.isEmpty()) pix.load(path);*/
  pix = kapp->iconLoader()->loadIcon("locale", KIcon::Small);
  menu->changeTitle(menu->idAt(0), pix, i18n("Keyboard Switch"));
}

KBSwitchTrayIcon::~KBSwitchTrayIcon(){
}

/** No descriptions */
void KBSwitchTrayIcon::slotMenuActivated(int id){
  if (id >= 0 && id < conf->groupCount()) emit groupSelected(id);
}

/** No descriptions */
void KBSwitchTrayIcon::setActiveGroup(int groupno){
  int i;
  KPopupMenu *menu = contextMenu();
  for (i = 0; i < conf->groupCount(); i++)
    menu->setItemChecked(i, false);
  menu->setItemChecked(groupno, true);
}

/** No descriptions */
void KBSwitchTrayIcon::setToggleGroups(int group1, int group2){
  int i;
  KPopupMenu *menu = contextMenu();

  for (i = 0; i < conf->groupCount(); i++)
    if (i == group1 || i == group2)
      menu->changeItem(i, conf->getGroup(i)->getName() + "*");
    else menu->changeItem(i, conf->getGroup(i)->getName());
}

/** No descriptions */
void KBSwitchTrayIcon::mouseReleaseEvent(QMouseEvent *event){
  if (event->button() == LeftButton) {
    emit clicked();
  }
}

/** No descriptions */
void KBSwitchTrayIcon::slotAbout(){
  KAboutApplication about;
  about.exec();
}

/** No descriptions */
void KBSwitchTrayIcon::updateIcons(){
  KPopupMenu *menu = contextMenu();
  for (int i = 0; i < conf->groupCount(); i++) {
    menu->changeItem(i, conf->getGroup(i)->getPixmap(), menu->text(i));
  }
}
