/***************************************************************************
                          kbconfigdlg.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBCONFIGDLG_H
#define KBCONFIGDLG_H

#include <qwidget.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <kdialogbase.h>

#include "kbconfig.h"

/**Configuration dialog for KKBSwitch
  *@author Leonid Zeitlin
  */

class KBConfigDlg : public KDialogBase  {
   Q_OBJECT
public: 
	KBConfigDlg(KBConfig *kbconf, QWidget *parent=0, const char *name=0);
	~KBConfigDlg();
private: // Private attributes
  /**  */
  KListBox *lbGroups;
  /**  */
  QCheckBox *chkToggleMode;
  QPushButton *btnChangeIcon;
  QStringList m_iconpaths;
  KBConfig *m_kbconf;
  /** Display the current KBSwitch configuration in the dialog */
  void showConfig();
private slots: // Private slots
  /** Fire up "Pick Icon" dialog */
  void slotPickIcon();
  /** No descriptions */
  void slotLayoutSelected();
  /** No descriptions */
  void slotListBoxExecuted(QListBoxItem *item);
private: // Private methods
  /** No descriptions */
  void saveConfig();
protected: // Protected methods
  /** No descriptions */
  virtual void slotApply();
protected: // Protected methods
  /** No descriptions */
  virtual void slotOk();
};

#endif
