/***************************************************************************
                          kbconfigdlg.cpp  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbconfigdlg.h"
#include "kbpickicondlg.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <klistbox.h>
#include <klocale.h>
#include <kdebug.h>
#include <kapp.h>

KBConfigDlg::KBConfigDlg(KBConfig *kbconf, QWidget *parent, const char *name )
  : KDialogBase(parent, name, true /*modal*/, i18n("Configure")/*caption*/) {
  m_kbconf = kbconf;
  QFrame *page = makeMainWidget();
  QVBoxLayout *vlayout = new QVBoxLayout(page);
  vlayout->setSpacing(2);

  QLabel *lbl = new QLabel(i18n("Available &keyboard groups"), page);
  vlayout->addWidget(lbl);

  QHBoxLayout *hlayout = new QHBoxLayout(vlayout);
  lbGroups = new KListBox(page);
  QObject::connect(lbGroups, SIGNAL(selectionChanged()), this, SLOT(slotLayoutSelected()));
  QObject::connect(lbGroups, SIGNAL(doubleClicked(QListBoxItem *)), this,
    SLOT(slotListBoxExecuted(QListBoxItem *)));
  hlayout->addWidget(lbGroups);
  lbl->setBuddy(lbGroups);

  btnChangeIcon = new QPushButton(i18n("Change Icon..."), page);
  QObject::connect(btnChangeIcon, SIGNAL(clicked()), this, SLOT(slotPickIcon()));
  hlayout->addWidget(btnChangeIcon, 0, Qt::AlignTop);

  chkToggleMode = new QCheckBox(i18n("Use \"Toggle Mode\""), page);
  vlayout->addWidget(chkToggleMode);
  slotLayoutSelected();

  showConfig();
}

KBConfigDlg::~KBConfigDlg(){
}

/** Display the current KBSwitch configuration in the dialog */
void KBConfigDlg::showConfig(){
  int i;
  KBGroup *group;
  KConfig *conf = kapp->config();

  m_iconpaths.clear();
  conf->setGroup(ICONS_SECTION);
  for (i = 0; i < m_kbconf->groupCount(); i++) {
    group = m_kbconf->getGroup(i);
    lbGroups->insertItem(group->getPixmap(), group->getName());
    m_iconpaths.append(conf->readEntry(KBConfig::entryForGroup(i)));
  }
  lbGroups->setMinimumHeight(lbGroups->itemHeight() * (m_kbconf->groupCount() + 1));
  chkToggleMode->setChecked(m_kbconf->toggle_mode());
}

/** Fire up "Pick Icon" dialog */
void KBConfigDlg::slotPickIcon(){
  KBPickIconDlg dlg(this);
  if (dlg.exec()) {
    QPixmap *pix = dlg.getIcon();
    if (pix) {
      int index = lbGroups->currentItem();
      lbGroups->changeItem(*pix, lbGroups->currentText(), index);
      m_iconpaths[index] = dlg.getIconPath();
    }
  }
}

/** No descriptions */
void KBConfigDlg::slotLayoutSelected(){
  btnChangeIcon->setEnabled(lbGroups->currentItem() != -1);
}

/** No descriptions */
void KBConfigDlg::slotListBoxExecuted(QListBoxItem *item){
  slotPickIcon();
}

/** No descriptions */
void KBConfigDlg::saveConfig(){
  QString path;
  QPixmap *pix;
  KConfig *conf = kapp->config();
  conf->setGroup(ICONS_SECTION);
  for (int i = 0; i < m_kbconf->groupCount(); i++) {
    path = m_iconpaths[i];
    if (!path.isEmpty()) conf->writeEntry(KBConfig::entryForGroup(i), path);
    pix = lbGroups->pixmap(i);
    if (pix) m_kbconf->getGroup(i)->setPixmap(*pix);
  }
  m_kbconf->set_toggle_mode(chkToggleMode->isChecked());
  conf->setGroup(OPTIONS_SECTION);
  conf->writeEntry(TOGGLE_MODE_ENTRY, m_kbconf->toggle_mode());

  m_kbconf->notifyChanged();
  conf->sync();
}

/** No descriptions */
void KBConfigDlg::slotOk(){
  saveConfig();
  KDialogBase::slotOk();
}

/** No descriptions */
void KBConfigDlg::slotApply(){
  saveConfig();
  KDialogBase::slotApply();
}
