//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>

#include "ktable.h"
#include "ktable.moc"

#include "klocale.h"

KTableBox::KTableBox(int w, int th, QString text, QWidget *parent=0)
  : QDialog(parent,0,TRUE)
{
  table = new QListBox(this);
  int width = w*fontMetrics().width("x")+16;
  int height = th*fontMetrics().height()+16;
  table->resize(width, height);

  label = new QLabel(text, this);
  label->setAlignment(AlignCenter);
  label->adjustSize();
  
  if (label->width() > width)
    width = label->width();

  ok = new QPushButton(i18n("&Ok"), this);
  cancel = new QPushButton(i18n("&Cancel"), this);
  ok->adjustSize();
  cancel->adjustSize();
  
  int btn_width = ok->width();
  if (cancel->width() > btn_width)
    btn_width = cancel->width();

  if (32+2*btn_width > width)
    width = 32+2*btn_width;

  label->move((width - label->width())/2, 8);    
  table->move(8,label->height()+16);
  table->resize(width-8,table->height());

  int btn_height = 32+label->height()+table->height();
  ok->setGeometry(width/2 - btn_width - 8, btn_height+8, btn_width, ok->height());
  cancel->setGeometry(width/2 + 8, btn_height+8, btn_width, ok->height());

  ok->setDefault(TRUE);

  connect(ok, SIGNAL(pressed()), this, SLOT(accept()));
  connect(cancel, SIGNAL(pressed()), this, SLOT(reject()));

  adjustSize();
  setFixedSize(this->width(), this->height());
}


void KMenuTable::insertItems(QStrList items)
{
  table->insertStrList(&items);
  table->setCurrentItem(0);
}

void KMenuTable::insertItem(QString item)
{
  table->insertItem(item);
  table->setCurrentItem(0);
}


int KMenuTable::getItem()
{
  return table->currentItem();
}
