//
//  Copyright (C) 1998 Matthias Hoelzer
//  email:  hoelzer@physik.uni-wuerzburg.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the7 implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <fcntl.h>
#include <unistd.h>

#include <qlist.h>
#include <qfile.h>
#include <qdstream.h>


#include "application.h"

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

static KCmdLineOptions options[] =
{
    { "kinit", I18N_NOOP("Initialise pipes"), 0 },
    { "+[arg]", 0, 0 },
    KCmdLineLastOption
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "kdialog", I18N_NOOP("kdialog"),
                        "0.2", I18N_NOOP( "The KDE dialog replacement" ), KAboutData::License_BSD,
                        "(C) 2000, Nick Thompson");
  aboutData.addAuthor("Nick Thompson",0, "nickthompson@lucent.com");

  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  Application app(argc, argv);

  return(app.exec());
}
