/***************************************************************************
                          optiondialog.cpp  -  description
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kprocess.h>

#include "optiondialog.h"
#include "optionstate.h"
#include "graphics.h"


COptionDialog::COptionDialog(QWidget *parent, char *name, bool modal)
   :KDialogBase(IconList, i18n("Configure the K Desktop Clock"), Help|Default|Apply|Ok|Cancel, Ok, parent,name, modal, true)
{
        setHelp ("kdclock/index.html",QString::null);

        setupModePage();
        setupFontPage();
        setupColorPage();
        setupBackgroundPage();
        setupMiscPage();
        setMinimumHeight(407);
        setMinimumWidth(480);
}

COptionDialog::~COptionDialog()
{
}

void COptionDialog::setState(const SOptionState &state)
{
	setMode(state.mode);
	setFont(state.font);
	setColor(state.color);
	setBackground(state.back);
	setMisc(state.misc);
}

void COptionDialog::slotOk(void)
{
    m_passed = true;
    slotApply();
    if (m_passed)
        accept();
}

void COptionDialog::slotApply(void)
{
    if (!checkValues())
    {
        m_passed = false;
        return;
    }
	int i=dmClock;
	if (RadioButton1->isChecked())
		i = dmClock;
	else
    if (RadioButton2->isChecked())
        i = dmCountdown;
    else
    if (RadioButton3->isChecked())
        i = dmStopWatch;

    options.mode.displayMode = i;
    options.mode.ampm = amCheck->isChecked();
    options.mode.countHourMin = hourEdit->text()+':'+minEdit->text();
    options.mode.enableAlarm = enableAlarmCheck->isChecked();
    options.mode.alarmFile = fileEdit->text();
    QString s = timeEdit->text();
    int h = getHour(s).toInt();
    int m = getMin(s).toInt();
    int se = getSec(s).toInt();
    if (QTime::isValid(h,m,se))
        options.mode.alarmTime = QTime(h,m,se);
    else
        options.mode.alarmTime = QTime(0,0);
    emit modeChoice(options.mode);

	options.font.font = fontChooser->font();
	emit fontChoice(options.font);

	options.color.foreground = foregroundButton->color();
	options.color.shadow = shadowButton->color();
	options.color.plain = contentButton->color();
	emit colorChoice(options.color);

	i = bmOneColor;
	options.back.backgroundColor1 = backgroundButton1->color();
	options.back.backgroundColor2 = backgroundButton2->color();
	options.back.backgroundPicture= backgroundFileEdit->text();
	if (RButton1->isChecked())
		i = bmOneColor;
	if (RButton2->isChecked())
		i = bmTwoColors;
	if (RButton3->isChecked())
		i = bmPicture;
	if (RButton4->isChecked())
		i = bmTransparent;
	options.back.effect = i;
	options.back.effectNumber = effectBox->currentItem();
	options.back.pictureMode = pictureMode->currentItem();
	options.back.pictureBackground = picBackground->currentItem();
	emit backgroundChoice(options.back);

	options.misc.beep = beepBox->isChecked();
	options.misc.showSeconds = secondsBox->isChecked();
	options.misc.showDate = dateBox->isChecked();
    options.misc.showDateShadow = dateShadowBox->isChecked();
    options.misc.showShadow = shadowBox->isChecked();
	options.misc.blinkingDots = blinkingBox->isChecked();
	options.misc.saveSettings = saveBox->isChecked();
    options.misc.dateFontSize = sizeBox->currentText().toInt();
    int fState = 0;
    if (italicBox->isChecked()) fState += 1;
    if (boldBox->isChecked()) fState += 2;
    if (underlineBox->isChecked()) fState += 4;
    options.misc.dateFontState = fState;
    options.misc.dateShadowDist = dateShadowDistBox->currentText().toInt();
    options.misc.shadowDist = shadowDistBox->currentText().toInt();
	emit miscChoice(options.misc);
    return;
}

bool COptionDialog::checkValues()
{
    int hours = hourEdit->text().toInt();
    if ((hours<0)||(hours>99))
    {
        QMessageBox::warning( this, "K D Clock", i18n("Please insert a number between 0 and 99."));
        hourEdit->setFocus();
        hourEdit->selectAll();
        return false;
    }
    int minutes = minEdit->text().toInt();
    if ((minutes<0)||(minutes>59))
    {
        QMessageBox::warning( this, "K D Clock", i18n("Please insert a number between 0 and 59."));
        minEdit->setFocus();
        minEdit->selectAll();
        return false;
    }

    options.mode.alarmFile = fileEdit->text();
    QString s = timeEdit->text();
    int h = getHour(s).toInt();
    int m = getMin(s).toInt();
    int se = getSec(s).toInt();
    if (!QTime::isValid(h,m,se,0))
    {
        if (enableAlarmCheck->isChecked())
        {
            QMessageBox::warning( this, "K D Clock", i18n("That is no valid time..."));
            timeEdit->setFocus();
            timeEdit->selectAll();
            return false;
        }
    }

    QFile qf(fileEdit->text());
    if ((!qf.exists()) && (enableAlarmCheck->isChecked()))
    {
        QMessageBox::warning( this, "K D Clock", i18n("This file does not exist!"));
        showPage(0);
        fileEdit->setFocus();
        fileEdit->selectAll();
        return false;
    }

    QFile qf2(backgroundFileEdit->text());
    if ((!qf2.exists()) && (RButton3->isChecked()))
    {
        QMessageBox::warning( this, "K D Clock", i18n("This file does not exist!"));
        showPage(3);
        backgroundFileEdit->setFocus();
        backgroundFileEdit->selectAll();
        return false;
    }
    bool b;
    int n = sizeBox->currentText().toInt(&b);
    if (!b)
    {
        QMessageBox::warning( this, "K D Clock", i18n("Please insert a valid size!"));
        showPage(4);
        sizeBox->setFocus();
        return false;
    }
    if ((n < 4) || (n > 64))
    {
        QMessageBox::warning( this, "K D Clock", i18n("Sorry, the font size must be between 4 and 64!"));
        showPage(4);
        sizeBox->setFocus();
        return false;
    }
    n = dateShadowDistBox->currentText().toInt(&b);
    if (!b)
    {
        QMessageBox::warning( this, "K D Clock", i18n("Please insert a valid number!"));
        showPage(4);
        dateShadowDistBox->setFocus();
        return false;
    }
    if ((n < 0) || (n > 50))
    {
        QMessageBox::warning( this, "K D Clock", i18n("Sorry, the distance must be between 0 and 50!"));
        showPage(4);
        dateShadowDistBox->setFocus();
        return false;
    }

    n = shadowDistBox->currentText().toInt(&b);
    if (!b)
    {
        QMessageBox::warning( this, "K D Clock", i18n("Please insert a valid number!"));
        showPage(4);
        shadowDistBox->setFocus();
        return false;
    }
    if ((n < 0) || (n > 50))
    {
        QMessageBox::warning( this, "K D Clock", i18n("Sorry, the distance must be between 0 and 50!"));
        showPage(4);
        shadowDistBox->setFocus();
        return false;
    }

	return true;
}

void COptionDialog::slotDefault(void)
{
    switch(activePageIndex())
    {
                case page_mode:
                        setMode(SModeState());
                        break;
                case page_font:
                        setFont(SFontState());
                        break;
                case page_colors:
                        setColor(SColorState());
                        break;
                case page_back:
                        setBackground(SBackgroundState());
                        break;
                case page_misc:
                        setMisc(SMiscState());
                        break;
    }
}

void COptionDialog::slotHelp(void)
{
        KDialogBase::slotHelp();
}

void COptionDialog::setupModePage(void)
{
        QFrame *page = addPage(i18n("Mode"), i18n("Clock mode"),
                QPixmap(clock));

        clockModeGroup = new QButtonGroup( page, "clockModeGroup" );
        clockModeGroup->setGeometry( QRect( 0, 0, 356, 70 ) );
        clockModeGroup->setTitle( i18n("Klock Mode"));

        RadioButton1 = new QRadioButton( clockModeGroup, "RadioButton1" );
        RadioButton1->setGeometry( QRect(14,29,105,20));
        RadioButton1->setText(i18n("&Normal"));

        RadioButton2 = new QRadioButton( clockModeGroup, "RadioButton2" );
        RadioButton2->setGeometry(QRect(125,29,105,20));
        RadioButton2->setText(i18n("&Countdown"));

        RadioButton3 = new QRadioButton( clockModeGroup, "RadioButton3" );
        RadioButton3->setGeometry( QRect(240,29,105,20));
        RadioButton3->setText(i18n("Stopp &watch"));

        normalGroup = new QButtonGroup( page, "normalGroup" );
        normalGroup->setGeometry( QRect( 0, 70, 356, 70 ) );
        normalGroup->setTitle( i18n( "Normal clock"  ) );

        amCheck = new QCheckBox( normalGroup, "amCheck" );
        amCheck->setGeometry( QRect( 19, 30, 150, 20 ) );
        amCheck->setText( i18n( "AM/&PM"  ) );

        countdownGroup = new QButtonGroup( page, "countdownGroup" );
        countdownGroup->setGeometry( QRect( 0, 140, 356, 70 ) );
        countdownGroup->setTitle( i18n( "Countdown clock"  ) );

        hourEdit = new QLineEdit( countdownGroup, "hourEdit" );
        hourEdit->setGeometry( QRect( 100, 27, 60, 22 ) );

        minEdit = new QLineEdit( countdownGroup, "minEdit" );
        minEdit->setGeometry( QRect( 275, 27, 60, 22 ) );

        TextLabel1 = new QLabel( countdownGroup, "TextLabel1" );
        TextLabel1->setGeometry( QRect( 21, 27, 80, 22 ) );
        TextLabel1->setText( i18n("Hours:"));

        TextLabel2 = new QLabel( countdownGroup, "TextLabel1" );
        TextLabel2->setGeometry( QRect( 185, 27, 80, 22 ) );
        TextLabel2->setText( i18n("Minutes:"));

        GroupBox1 = new QGroupBox( page, "GroupBox1" );
        GroupBox1->setGeometry( QRect( 0, 210, 356, 110 ) );
        GroupBox1->setTitle( i18n( "Alarm"  ) );

        enableAlarmCheck = new QCheckBox( GroupBox1, "enableAlarmCheck" );
        enableAlarmCheck->setGeometry( QRect( 20, 20, 140, 20 ) );
        enableAlarmCheck->setText( i18n( "enable &alarm"  ) );

        timeEdit = new QLineEdit( GroupBox1, "timeEdit" );
        timeEdit->setGeometry( QRect( 129, 45, 180, 22 ) );

        fileEdit = new QLineEdit( GroupBox1, "fileEdit" );
        fileEdit->setGeometry( QRect( 130, 75, 180, 22 ) );

        PushButton1 = new QPushButton( GroupBox1, "PushButton1" );
        PushButton1->setGeometry( QRect( 315, 71, 32, 32 ) );
        PushButton1->setText("");
        PushButton1->setPixmap( QPixmap(open_data));
        connect(PushButton1,SIGNAL(clicked()),SLOT(alarmFileEditClicked()));

        TextLabel1_2 = new QLabel( GroupBox1, "TextLabel1_2" );
        TextLabel1_2->setGeometry( QRect( 20, 45, 100, 22 ) );
        TextLabel1_2->setText( i18n( "Time:"  ) );

        TextLabel1_2_2 = new QLabel( GroupBox1, "TextLabel1_2_2" );
        TextLabel1_2_2->setGeometry( QRect( 21, 75, 100, 22 ) );
        TextLabel1_2_2->setText( i18n( "File:"  ) );
}

void COptionDialog::setupFontPage(void)
{
        QVBox *page = addVBoxPage(i18n("Font"),i18n("Font for the digital clock"),QPixmap(fonts));
        fontChooser = new KFontChooser (page,"font",false,QStringList(),false,6);
        fontChooser->setSampleText(QTime::currentTime().toString());
}

void COptionDialog::setupColorPage(void)
{
        QFrame *page = addPage(i18n("Colors"), i18n("Colors"),QPixmap(colors));
        QVBoxLayout *topLayout = new QVBoxLayout(page,0,spacingHint());
        QGridLayout *gbox = new QGridLayout(5,2);
        topLayout->addLayout(gbox);

        QLabel *label1;
        QLabel *label2;
        QLabel *label3;
        foregroundButton = new KColorButton(page);
        shadowButton = new KColorButton(page);
        contentButton = new KColorButton(page);
        /*foregroundButton->setColor(options.color.foreground);
        shadowButton->setColor(options.color.shadow);
        contentButton->setColor(options.color.fill);*/
        label1 = new QLabel(i18n("Foreground color:"),page);
        label2 = new QLabel(i18n("Shadow color:"),page);
        label3 = new QLabel(i18n("Content color:"),page);
        gbox->addWidget(label1,0,0);
        gbox->addWidget(label2,1,0);
        gbox->addWidget(label3,2,0);
        gbox->addWidget(foregroundButton,0,1);
        gbox->addWidget(shadowButton,1,1);
        gbox->addWidget(contentButton,2,1);
        topLayout->addStretch(10);
}

void COptionDialog::setupBackgroundPage()
{
        QFrame *page = addPage(i18n("Background"), i18n("Configure background"),QPixmap(background));

        backgroundGroup = new QButtonGroup( page, "backgroundGroup" );
        backgroundGroup->setGeometry( QRect( 0, 0, 356, 90 ) );
        backgroundGroup->setTitle( i18n("Background Mode"));

        RButton1 = new QRadioButton(i18n("One color"),backgroundGroup);
        RButton1->setGeometry( QRect(11,29,155,20));
        RButton2 = new QRadioButton(i18n("Two colors"),backgroundGroup);
        RButton2->setGeometry( QRect(170,29,155,20));
        RButton3 = new QRadioButton(i18n("Picture"),backgroundGroup);
        RButton3->setGeometry( QRect(11,55,155,20));
        RButton4 = new QRadioButton(i18n("Transparent"),backgroundGroup);
        RButton4->setGeometry( QRect(170,55,155,20));

        backgroundGroup->setButton(bmOneColor);

        QLabel *label1;
        QLabel *label2;
        QLabel *label3;
        QLabel *label4;
        QLabel *label5;
        QLabel *label6;
        label1 = new QLabel(i18n("Background color 1:"),page);
        label1->setGeometry( QRect( 0, 110, 140, 20 ) );
        label2 = new QLabel(i18n("Background color 2:"),page);
        label2->setGeometry( QRect( 0, 140, 140, 20 ) );
        label3 = new QLabel(i18n("Effect:"),page);
        label3->setGeometry( QRect( 0, 170, 140, 20 ) );
        label4 = new QLabel(i18n("Background picture:"),page);
        label4->setGeometry( QRect( 0, 200, 140, 20 ) );
        label5 = new QLabel(i18n("Picture mode:"),page);
        label5->setGeometry( QRect( 0, 230, 140, 20 ) );
        label6 = new QLabel(i18n("Picture background:"),page);
        label6->setGeometry( QRect( 0, 260, 140, 20 ) );
        backgroundButton1 = new KColorButton(page);
        backgroundButton1->setGeometry( QRect( 160, 105, 170, 30 ) );
        backgroundButton2 = new KColorButton(page);
        backgroundButton2->setGeometry( QRect( 160, 135, 170, 30 ) );
        effectBox = new QComboBox( false, page);
        effectBox->setGeometry( QRect(162, 167, 166,26));
        effectBox->insertItem(i18n("Horizontal gradient"));
        effectBox->insertItem(i18n("Vertical gradient"));
        effectBox->insertItem(i18n("Pyramid gradient"));
        effectBox->insertItem(i18n("Pipecross gradient"));
        effectBox->insertItem(i18n("Elliptic gradient"));
        effectBox->insertItem(i18n("Diagonal gradient"));
        effectBox->insertItem(i18n("Cross diagonal gradient"));
        effectBox->insertItem(i18n("Rectangle gradient"));
        backgroundFileEdit = new QLineEdit(page);
        backgroundFileEdit->setGeometry( QRect( 162, 198, 166, 24 ) );
        chooseFileButton = new QPushButton( page);
        chooseFileButton->setGeometry( QRect( 330, 196, 30, 30 ) );
        chooseFileButton->setText("");
        chooseFileButton->setPixmap( QPixmap(open_data));
        connect(chooseFileButton,SIGNAL(clicked()),SLOT(backgroundPictureClicked()));
        pictureMode = new QComboBox(false,page);
        pictureMode ->setGeometry( QRect( 162, 227, 166, 26 ) );
        pictureMode ->insertItem(i18n("Centered"));
        pictureMode ->insertItem(i18n("Centered Maxpect"));
        pictureMode ->insertItem(i18n("Stretched"));
        pictureMode ->insertItem(i18n("Tiled"));
        picBackground = new QComboBox(false,page);
        picBackground->setGeometry(QRect( 162, 257 , 166, 26 ) );
        picBackground->insertItem(i18n("One color"));
        picBackground->insertItem(i18n("Two colors"));
        picBackground->insertItem(i18n("Transparent"));
}

void COptionDialog::setupMiscPage()
{
    QFrame *page = addPage(i18n("Miscellaneous"), i18n("Miscellaneous"),QPixmap(misc));
    QVBoxLayout *topLayout = new QVBoxLayout(page,0,spacingHint());
    QGridLayout *grid = new QGridLayout(12,4);
    topLayout->addLayout(grid);

    secondsBox = new QCheckBox( page, "secondsBox" );
    secondsBox->setText( i18n( "Show &seconds"  ) );

    beepBox = new QCheckBox( page, "beepBox" );
    beepBox->setText( i18n( "Beep every &hour"  ) );

    grid->addMultiCellWidget( beepBox, 0, 0, 0, 2 );
    grid->addMultiCellWidget( secondsBox, 1, 1, 0, 2 );

    dateBox = new QCheckBox( page, "dateBox" );
    dateBox->setText( i18n( "Show &date"  ) );

    grid->addMultiCellWidget( dateBox, 2, 2, 0, 2 );

    TextLabel1 = new QLabel(page, "TextLabel1");
    TextLabel1->setText(i18n("Font size:"));

    grid->addWidget( TextLabel1, 3, 1 );

    sizeBox = new QComboBox( FALSE, page, "sizeBox" );
    sizeBox->insertItem( "4" );
    sizeBox->insertItem( "5" );
    sizeBox->insertItem( "6" );
    sizeBox->insertItem( "7" );
    sizeBox->insertItem( "8" );
    sizeBox->insertItem( "9" );
    sizeBox->insertItem( "10" );
    sizeBox->insertItem( "11" );
    sizeBox->insertItem( "12" );
    sizeBox->insertItem( "13" );
    sizeBox->insertItem( "14" );
    sizeBox->insertItem( "15" );
    sizeBox->insertItem( "16" );
    sizeBox->insertItem( "17" );
    sizeBox->insertItem( "18" );
    sizeBox->insertItem( "19" );
    sizeBox->insertItem( "20" );
    sizeBox->insertItem( "22" );
    sizeBox->insertItem( "24" );
    sizeBox->insertItem( "26" );
    sizeBox->insertItem( "28" );
    sizeBox->insertItem( "32" );
    sizeBox->insertItem( "36" );
    sizeBox->insertItem( "48" );
    sizeBox->setEditable( TRUE );
    grid->addWidget( sizeBox, 3, 2 );
    boldBox = new QCheckBox( page, "boldBox" );
    boldBox->setText( i18n( "&Bold"  ) );
    grid->addWidget( boldBox, 4, 1 );

    italicBox = new QCheckBox( page, "italicBox" );
    italicBox->setText( i18n( "&Italic"  ) );
    grid->addWidget( italicBox, 4, 2 );

    underlineBox = new QCheckBox( page, "underlineBox" );
    underlineBox->setText( i18n( "&Underline"  ) );
    grid->addWidget( underlineBox, 4, 3 );

    dateShadowBox = new QCheckBox( page, "dateShadowBox" );
    dateShadowBox->setText( i18n( "Show shadow &of date"  ) );
    grid->addMultiCellWidget( dateShadowBox, 5, 5, 1, 2);

    QLabel * TextLabel2 = new QLabel(page, "TextLabel1");
    TextLabel2->setText(i18n("Shadow distance:"));
    grid->addWidget( TextLabel2, 6, 1 );

    dateShadowDistBox = new QComboBox(false, page, "dateShadowDistBox");
    for (int i = 0; i < 20; i++)
    {
        QString s;
        s.setNum(i);
        dateShadowDistBox->insertItem(s);
    }
    dateShadowDistBox->setEditable(true);
    grid->addWidget(dateShadowDistBox, 6, 2);

    shadowBox = new QCheckBox( page, "shadowBox" );
    shadowBox->setText( i18n( "Show shado&w"  ) );
    grid->addMultiCellWidget( shadowBox, 7, 7, 0, 2 );

    QLabel * TextLabel3 = new QLabel(page, "TextLabel1");
    TextLabel3->setText(i18n("Shadow distance:"));
    grid->addWidget( TextLabel3, 8, 1 );

    shadowDistBox = new QComboBox(false, page, "shadowDistBox");
    for (int i = 0; i < 20; i++)
    {
        QString s;
        s.setNum(i);
        shadowDistBox->insertItem(s);
    }
    shadowDistBox->setEditable(true);
    grid->addWidget(shadowDistBox, 8, 2);

    blinkingBox = new QCheckBox( page, "blinkingBox" );
    blinkingBox->setText( i18n( "&Blinking dots"  ) );
    grid->addMultiCellWidget( blinkingBox, 9, 9, 0, 2 );

    saveBox = new QCheckBox( page, "saveBox" );
    saveBox->setText( i18n( "Save settings on &exit"  ) );
    grid->addMultiCellWidget( saveBox, 10, 10, 0, 2 );

    adjustButton = new QPushButton( page, "adjustButton" );
    adjustButton->setText( i18n( "&Adjust date/time"  ) );
    grid->addMultiCellWidget( adjustButton, 11, 11, 0, 1 );
    topLayout->addStretch(10);

    connect(adjustButton,SIGNAL(clicked()),SLOT(adjustDateTime()));
    //QMessageBox::warning( this, "Klock", "layout3");

/*        QVBoxLayout *topLayout = new QVBoxLayout(page,0,spacingHint());
        QGridLayout *gbox = new QGridLayout(8,2);
        topLayout->addLayout(gbox);

        beepBox = new QCheckBox(i18n("Beep every Hour"),page);
        secondsBox = new QCheckBox(i18n("Show Seconds"),page);
        dateBox = new QCheckBox(i18n("Show Date"),page);
        shadowBox = new QCheckBox(i18n("Show Shadow"),page);
        blinkingBox = new QCheckBox (i18n("Blinking dots"),page);
        saveBox = new QCheckBox(i18n("Save settings on exit"),page);
        adjustButton = new QPushButton(page);
        QLabel *label = new QLabel(" ",page);
        adjustButton->setText(i18n("Adjust date/time"));
        gbox->addWidget(beepBox,0,0);
        gbox->addWidget(secondsBox,1,0);
        gbox->addWidget(dateBox,2,0);
        gbox->addWidget(shadowBox,3,0);
        gbox->addWidget(blinkingBox,4,0);
        gbox->addWidget(saveBox,5,0);
        gbox->addWidget(label,6,0);
        gbox->addWidget(adjustButton,7,0);
        topLayout->addStretch(10);*/
}

QString COptionDialog::getHour(QString s)
{
        for (uint i=0;i<s.length();i++)
        {
                if (s[i]==':')
                {
                        return s.left(i);
                }
        }
        return s;
}

QString COptionDialog::getMin(QString s)
{
        int n=0;int m=0;
        for (uint i=0;i<s.length();i++)
        {
                if ((s[i]==':') && (n==0))
                {
                        n=i;
                }
                else
                if (s[i]==':')
                {
                        m=i;
                }
        }
        if (m==0) m=s.length();
        return s.mid(n+1,m-n-1);
}

QString COptionDialog::getSec(QString s)
{
        int n=0;
        for (uint i=0;i<s.length();i++)
        {
                if (s[i]==':')
                        n=i;
        }
        return s.right(s.length()-n-1);
}

void COptionDialog::alarmFileEditClicked(void)
{
        QString f = KFileDialog::getOpenFileName (QString::null, "*.wav|Wave-File", this);
        if (!f.isEmpty())
            fileEdit->setText(f);
}

void COptionDialog::backgroundPictureClicked(void)
{
        QString f = KFileDialog::getOpenFileName
            (QString::null, "*.png *.xpm *.jpeg *.xbm *.bmp", this);
        if (!f.isEmpty())
            backgroundFileEdit->setText(f);
}

void COptionDialog::adjustDateTime()
{
        // the following code was taken from panel applet "clock"
        KProcess proc;
        proc << locate("exe", "kdesu");
        proc << locate("exe", "kcmshell");
        proc << "System/clock";
        proc.start(KProcess::DontCare);
}

void COptionDialog::setMode(const SModeState &mode)
{
        options.mode = mode;
        clockModeGroup->setButton(options.mode.displayMode);
        amCheck->setChecked(options.mode.ampm);
        hourEdit->setText(getHour(options.mode.countHourMin));
        minEdit->setText(getMin(options.mode.countHourMin));
        enableAlarmCheck->setChecked(options.mode.enableAlarm);
        fileEdit->setText(options.mode.alarmFile);
        timeEdit->setText(options.mode.alarmTime.toString());
}

void COptionDialog::setFont(const SFontState &font)
{
        options.font = font;
        fontChooser->setFont(options.font.font,false);
}

void COptionDialog::setColor(const SColorState &color)
{
        options.color = color;
        foregroundButton->setColor(options.color.foreground);
        shadowButton->setColor(options.color.shadow);
        contentButton->setColor(options.color.plain);
}

void COptionDialog::setBackground(const SBackgroundState &back)
{
        options.back = back;
        backgroundButton1->setColor(options.back.backgroundColor1);
        backgroundButton2->setColor(options.back.backgroundColor2);
        backgroundFileEdit->setText(options.back.backgroundPicture);
        backgroundGroup->setButton(options.back.effect);
        effectBox->setCurrentItem(options.back.effectNumber);
        pictureMode->setCurrentItem(options.back.pictureMode);
        picBackground->setCurrentItem(options.back.pictureBackground);
}

void COptionDialog::setMisc(const SMiscState &misc)
{
        options.misc = misc;
        beepBox->setChecked(options.misc.beep);
        secondsBox->setChecked(options.misc.showSeconds);
        dateBox->setChecked(options.misc.showDate);
        dateShadowBox->setChecked(options.misc.showDateShadow);
        shadowBox->setChecked(options.misc.showShadow);
        blinkingBox->setChecked(options.misc.blinkingDots);
        saveBox->setChecked(options.misc.saveSettings);
        QString s;
        sizeBox->setEditText(s.setNum(options.misc.dateFontSize));
        dateShadowDistBox->setEditText(s.setNum(options.misc.dateShadowDist));
        shadowDistBox->setEditText(s.setNum(options.misc.shadowDist));
        int fState = options.misc.dateFontState;
        if (fState - fUnderline >=0)
        {
            fState -= fUnderline;
            underlineBox->setChecked(true);
        }
        else
            underlineBox->setChecked(false);
        if (fState - fBold >=0)
        {
            fState -= fBold;
            boldBox->setChecked(true);
        }
        else
            boldBox->setChecked(false);
        if (fState - fItalic >=0)
        {
            fState -= fItalic;
            italicBox->setChecked(true);
        }
        else
            italicBox->setChecked(false);
}






