/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "settings.h"
#include "resources.h"

#include <qstring.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>

#include <stdlib.h>

const QString Defaults::Save::customDateFormat="%Y-%m-%d %H:%M+%Z";


QString Defaults::Identity::authorName()
{
   if(_authorName.isNull())
   {
      KConfig mailConf("emaildefaults",true);
      mailConf.setGroup("UserInfo");

      _authorName=mailConf.readEntry("FullName","");
   }

   return _authorName;
}

QString Defaults::Identity::authorEmail()
{
   if(_authorEmail.isNull())
   {
      KConfig mailConf("emaildefaults",true);
      mailConf.setGroup("UserInfo");

      _authorEmail=mailConf.readEntry("EmailAddress","");
   }

   return _authorEmail;
}

QString Defaults::Identity::mailingList()
{
   if(_mailingList.isNull())
   {
      QString lang="de_DE";//=Defaults::Search::defaultLang();
      int temp=lang.find("_");
      lang=lang.left(temp);
      _mailingList=lang+"@li.org";
   }

   return _mailingList;
}

QString Defaults::Identity::languageName()
{
   if(_languageName.isNull())
   {
      _languageName="";
   }

   return _languageName;
}

QString Defaults::Identity::timezone()
{
   if(_timezone.isNull())
   {
     _timezone=getenv("TIMEZONE");
     if(_timezone.isEmpty())
       _timezone="GMT";
   }

   return _timezone;
}


QString Defaults::Identity::_authorName=QString::null;
QString Defaults::Identity::_authorEmail=QString::null;
QString Defaults::Identity::_mailingList=QString::null;
QString Defaults::Identity::_timezone=QString::null;
QString Defaults::Identity::_languageName=QString::null;


QString Defaults::Search::defaultLanguage()
{
   if(_defaultLanguage.isNull())
   {
      // first try to get the language from KDE settings
      QString lang=KGlobal::locale()->languages();
      if(lang.isEmpty())
      {
         lang=getenv("LC_ALL");
         if(lang.isEmpty())
         {
            lang=getenv("LC_MESSAGES");
            if(lang.isEmpty())
            {
               lang=getenv("LANG");
            }
         }
      }
      else
      {
         // use primary language
         int index=lang.find(":");
         if(index!=-1)
            lang=lang.left(index);
      }

      _defaultLanguage=lang;
   }
   return _defaultLanguage;
}

const QString Defaults::Search::otherIgnores=QString::null;
const QString Defaults::Search::moPath="";
const QString Defaults::Search::compendium="@LANG@.messages";
const QString Defaults::Search::auxiliary="../de/@PACKAGE@.po";

QString Defaults::Search::_defaultLanguage=QString::null;



QString Defaults::CatalogManager::poBaseDir()
{
   if(_poBaseDir.isNull())
   {
      _poBaseDir="";
   }

   return _poBaseDir;
}

QString Defaults::CatalogManager::potBaseDir()
{
   if(_potBaseDir.isNull())
   {
      _potBaseDir="";
   }

   return _potBaseDir;
}


QStringList Defaults::CatalogManager::dirCommands()
{
   QStringList cmds;
   cmds.append("make");
   cmds.append("make install");
   cmds.append("cvs update");

   return cmds;
}

QStringList Defaults::CatalogManager::dirCommandNames()
{
   QStringList cmds;
   cmds.append(i18n("Make"));
   cmds.append(i18n("Make install"));
   cmds.append(i18n("Update CVS"));

   return cmds;
}

QStringList Defaults::CatalogManager::fileCommands()
{
   QStringList cmds;

   cmds.append("@PACKAGE@");
   cmds.append("msgfmt -o @PACKAGE@.gmo @PACKAGE@.po");

   return cmds;
}

QStringList Defaults::CatalogManager::fileCommandNames()
{
   QStringList cmds;

   cmds.append(i18n("Run Application"));
   cmds.append(i18n("Compile"));

   return cmds;
}

QString Defaults::CatalogManager::_poBaseDir=QString::null;
QString Defaults::CatalogManager::_potBaseDir=QString::null;
