/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _UPDATEDLG_H_
#define _UPDATEDLG_H_

#include <qdialog.h>
#include <qradiobutton.h>
#include <qlineedit.h>

class QButtonGroup;


class UpdateDialog : public QDialog
{
    Q_OBJECT

public:
    UpdateDialog( QWidget *parent=0, const char *name=0 );
    ~UpdateDialog();
    bool byTag()
        { return bytag_button->isChecked(); }
    QString tag()
        { return tag_edit->text(); }
    QString date()
        { return date_edit->text(); }

private slots:
    void toggled();
    
private:
    QRadioButton *bytag_button, *bydate_button;
    QLineEdit *tag_edit, *date_edit;
    QButtonGroup *group;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
