/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_


#include <ktmainwindow.h>
#include "commitdlg.h"
#include "checkoutdlg.h"
#include "watchdlg.h"
#include "tagdlg.h"


class KAccel;
class QTimer;
class UpdateView;
class ProtocolView;
class QSplitter;
class KNewPanner;


class TopLevel : public KTMainWindow
{
    Q_OBJECT

public:

    TopLevel(const char *name=0);
    ~TopLevel();

    void openSandbox(QString dirname);
    //    void parseStatus(QString pathname, QStrList list);
    void restorePseudo(QString dirname);
    
protected:

    virtual void readProperties(KConfig *config);
    virtual void saveProperties(KConfig *config);
    virtual bool queryExit();

    void setupAccel();
    void updateAccel();
    void setupMenuBar();
    void setupToolBar();
    void setupStatusBar();        

protected slots:

    void popupRequested();
    void updateMenu();
    void fillRecentPopup();
    void recentActivated(int n);
    void aboutCervisia();

    void slotOpenSandbox();
    void slotOpen();
    void slotResolve();
    void slotStatus();
    void slotUpdate();
    void slotChangeLog();
    void slotCommit();
    void slotAdd();
    void slotAddBinary();
    void slotRemove();
    void slotExit();
    void slotBrowseLog();
    //    void slotBrowseMultiLog();
    void slotAnnotate();
    void slotDiff();
    void slotLastChange();
    void slotHistory();
    void slotCheckout();
    void slotImport();
    void slotRepositories();
    void slotCreateTag();
    void slotDeleteTag();
    void slotUpdateToTag();
    void slotUpdateToHead();
    void slotMerge();
    void slotAddWatch();
    void slotRemoveWatch();
    void slotShowWatchers();
    void slotMakePatch();
    void slotCreateDirs();
    void slotPruneDirs();
    void slotUpdateRecursive();
    void slotCommitRecursive();
    void slotDoCVSEdit();
    void slotSettings();
    void slotConfigureKeys();
    void slotHelp();
    void slotCVSInfo();
    void slotJobFinished(bool /*success*/);

private:    

    void updateOrStatus(bool noact, QString extraopt);
    void commitOrAddOrRemove(CommitDialog::ActionType action);
    void addOrRemoveWatch(WatchDialog::ActionType action);
    void importOrCheckout(CheckoutDialog::ActionType action);
    void createOrDeleteTag(TagDialog::ActionType action);
    void showJobStart(QString command);

    KAccel *accel;
    QPopupMenu *file, *recent, *view, *options, *repo, *advanced, *help;
    UpdateView *update;
    ProtocolView *protocol;
#if QT_VERSION >= 200
    QSplitter *splitter;
#else
    KNewPanner *splitter;
#endif
    QTimer *timer;
    int file_sandbox, file_recent;
    int file_open, file_resolv;
    int file_update, file_status;
    int file_chlog, file_commit, file_add, file_addbin, file_remove, file_exit;
    int view_mlog, view_log, view_anno, view_diff, view_change, view_history;
    int view_desel, view_unfold;
    int advanced_tag, advanced_deltag, advanced_uptag, advanced_uphead, advanced_merge;
    int advanced_addwatch, advanced_remwatch, advanced_watchers, advanced_patch;
    int repo_checkout, repo_import, repo_repos;
    int options_create, options_prune;
    int options_updaterecur, options_commitrecur, options_docvsedit;
    int options_sett, options_keys;
    int help_help;

    QString sandbox;
    QString repository;

    QString changelogstr;
    QStrList recentFiles;
    QStrList recentCommits;
    bool opt_createDirs, opt_pruneDirs;
    bool opt_updateRecursive, opt_commitRecursive, opt_doCVSEdit;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
