/***************************************************************************
                          skymap.cpp  -  description
                             -------------------
    begin                : Fri Nov 12 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include <qpainter.h>
#include <qpixmap.h>
#include <qscrollview.h>

#include "skymap.h"
#include "datainfo.h"

extern bool SKYMAP_VISIBLE;
extern bool SHOW_TEXT;
extern bool FILL_MARKER;
extern int MARKER_SIZE;

////////////////////////////////////////////////////////////////////
// SkyPic methods

SkyPic::SkyPic(QWidget* parent, const char *name) : QWidget(parent)
{
list = ((SkyMap*)parent)->skyposList();

pic_options = new KPopupMenu("Skymap");
pic_options->setCheckable(true);
pic_options->insertItem(i18n("Show Text"), ShowText);
pic_options->insertSeparator();
pic_options->insertItem(i18n("Small Marker"), SmallMarker);
pic_options->insertItem(i18n("Normal Marker"), NormalMarker);
pic_options->insertItem(i18n("Large Marker"), LargeMarker);
pic_options->insertSeparator();
pic_options->insertItem(i18n("Fill Marker"), FillMarker);
connect(pic_options, SIGNAL(activated(int)), SLOT(handlePopupCommand(int)));
connect(pic_options, SIGNAL(aboutToShow()), SLOT(checkPopupStatus()));
}

/*------------------------------------------------------------------------ */
SkyPic::~SkyPic()
{
}

/*------------------------------------------------------------------------ */
void SkyPic::paintEvent(QPaintEvent *e)
{
QPainter p;
QBrush bru;
QPen pen;
QString id;
SkyPos *pos;
int x, y;
	
p.begin( this );	
for( pos=list->first(); pos != 0; pos=list->next() )
  {
  pen.setColor(pos->color);
  bru.setColor(pos->color);
  if(FILL_MARKER)
    bru.setStyle(SolidPattern);
  else
    bru.setStyle(NoBrush);		
  p.setPen(pen);
  p.setBrush(bru);
  x = (int)(484.0 - (pos->ra*965.0)/24.0);
  if(x < 0) x = 965 + x;
  y = (int)(241.0 - (pos->dec*482.0)/180.0);
  p.drawEllipse(x-MARKER_SIZE*3,y-MARKER_SIZE*3,MARKER_SIZE*6,MARKER_SIZE*6);
  if(SHOW_TEXT)
    {
    id = pos->location + "\n" + pos->time_recorded;
    QRect r = p.boundingRect(0, 0, 10000, 10000, 0, (const char *)id);
    p.drawText(x-(r.width()/2), y-r.height()-MARKER_SIZE*3-1,
               r.width(), r.height(), AlignCenter|DontClip, id);
    }
  }
p.end();
}

/*------------------------------------------------------------------------ */
void SkyPic::mousePressEvent(QMouseEvent *e)
{
if(e->button() == RightButton)
  {
  pic_options->popup(QCursor::pos());
  }
}

/*------------------------------------------------------------------------ */
void SkyPic::checkPopupStatus()
{
pic_options->setItemChecked(ShowText, SHOW_TEXT);
pic_options->setItemChecked(FillMarker, FILL_MARKER);
for(int i=SmallMarker;i<=LargeMarker;i++)
  {
  pic_options->setItemChecked(i, false);
  }
pic_options->setItemChecked(MARKER_SIZE+SmallMarker-1, true);
}

/*------------------------------------------------------------------------ */
void SkyPic::handlePopupCommand(int id)
{
switch(id)
	{
	case ShowText: // handle the text display
		{
		SHOW_TEXT = !SHOW_TEXT;
		break;
		}
	case FillMarker: // fill marker?
		{
		FILL_MARKER = !FILL_MARKER;
		break;
		}
	default: // marker size
		{
		if(id >= SmallMarker && id <= LargeMarker) MARKER_SIZE = id - SmallMarker + 1;
		break;
		}
	}

update();
}


////////////////////////////////////////////////////////////////////
// SkyMap methods		

SkyMap::SkyMap(QPixmap* sm, QWidget* parent, const char* name )
       : QWidget(parent)
{
SeLi.setAutoDelete(true);

setCaption(i18n("Skymap (right click for menu)"));
setMinimumSize(100, 100);

QSize s(sm->size());

view = new QScrollView(this);
pic = new SkyPic(this);
pic->setBackgroundPixmap(*sm);
pic->resize(s);
view->addChild(pic);
view->setFocusProxy(this);
view->setFocusPolicy(QWidget::StrongFocus);

QWidget* d = QApplication::desktop();
int w = d->width();                   // returns screen width
int h = d->height();                  // returns screen height
int w_sm(0), h_sm(0);                 // width and height of starmap window
// +4 had to be added to avoid scroll bars in max mode (Qt 2.2)
if(s.width() < w) w_sm = s.width()+4; else {w_sm = w - 8; h_sm = 16;}
if(s.height() < h) h_sm += s.height()+4; else h_sm = h;	
resize(w_sm, h_sm);
setMaximumSize(w_sm, h_sm);	

SKYMAP_VISIBLE = true;	
}

/*------------------------------------------------------------------------ */
SkyMap::~SkyMap()
{
SeLi.clear();
}

/*------------------------------------------------------------------------ */
void SkyMap::closeEvent(QCloseEvent* e)
{
SKYMAP_VISIBLE = false;
QWidget::closeEvent(e);
}

/*------------------------------------------------------------------------ */
void SkyMap::resizeEvent(QResizeEvent* e)
{
view->resize(this->size());
}

/*------------------------------------------------------------------------ */
void SkyMap::addLocation(SetiLoc* loc)
{
//pic->addLocation(loc);
if(!loc->timeRecorded().isEmpty())
	{
	SkyPos *spos = new SkyPos;

	// fill the SkyPos structure
	spos->location = loc->description();
	spos->time_recorded = loc->timeRecordedString();
	spos->color = loc->color();
	spos->ra = loc->startRA();
	spos->dec = loc->startDec();

	// and add it to the list
	SeLi.append(spos);
  pic->update();
	}
	
connect(loc, SIGNAL(newWorkUnit(WorkUnitData, const QString&, const QColor&)),
     this, SLOT(updateLocation(WorkUnitData, const QString&, const QColor&)));
}

/*------------------------------------------------------------------------ */
void SkyMap::addLocation(SetiLoc* loc, const QString& time_rec,
                         double ra, double dec)
{
SkyPos *spos = new SkyPos;

// fill the SkyPos structure
spos->location = loc->description();
spos->time_recorded = time_rec;
spos->color = loc->color();
spos->ra = ra;
spos->dec = dec;

// and add it to the list
SeLi.append(spos);
pic->update();
}

/*------------------------------------------------------------------------ */
void SkyMap::clearMap()
{
SeLi.clear();
pic->setBackgroundPixmap(*pic->backgroundPixmap());
}

/*------------------------------------------------------------------------ */
void SkyMap::updateLocation(WorkUnitData wud, const QString& locname,
                            const QColor& col)
{
for(SkyPos* pos=SeLi.first(); pos != 0; pos=SeLi.next() )
	{
	if(pos->location == locname)
		{
		pos->time_recorded = wud.time_recorded;
		pos->color = col;
		pos->ra = wud.start_ra;
		pos->dec = wud.start_dec;
    pic->update();
		break;
		}
	}
}

#include "skymap.moc"

