/***************************************************************************
                          ksetiwatch.cpp  -  description
                             -------------------
    begin                : Fre Okt 22 17:39:47 CEST 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kstatusbar.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <ktabctl.h>
#include <kconfig.h>

#include <qlist.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qpopupmenu.h>

#include <unistd.h>

#include "analysis.h"
#include "datainfo.h"
#include "userinfo.h"
#include "completedwulist.h"
#include "options.h"
#include "about.h"
#include "dockwidget.h"
#include "seticontainer.h"
#include "skymap.h"
#include "ksetiwatch.h"

// skymap-related variables
SkyMap	*SKYMAP = 0;
bool		SKYMAP_LOADED = false;
bool		SKYMAP_VISIBLE = false;
bool		SHOW_TEXT = true;
bool		FILL_MARKER = true;
int			MARKER_SIZE = 2;

extern QList<SetiLoc> SetiList;

extern int		RefreshInterval;
extern bool		HMS;
extern bool		NEWPEAK_RECORD;
extern bool		NEWPEAK_CURRENTWU;
extern WUScore Record;
extern bool		MINIMIZETOPANEL;
extern bool   DRAWGRID;


Ksetiwatch::Ksetiwatch(const char* name) : KMainWindow(0, name)
{
	QString tlabel[6] = {
											i18n("Analysis"),
											i18n("Data Info"),
											i18n("User Info"),
											i18n("Completed Work Units"),
											i18n("Options"),
											i18n("About")
											};
		
	SetiContainer::initWUScore(&Record);
	readConfig();
	
  // load the skymap
  loader = new KIconLoader();
  if(loader)
  	{
		StarMap = loader->loadIcon("starmap", KIcon::User, 0, KIcon::DefaultState, 0, true);
		SKYMAP_LOADED = !StarMap.isNull();
		
		QPixmap iconpic;
		iconpic = loader->loadIcon("ksetiwatch", KIcon::Desktop);
		setIcon(iconpic);
	  }
	delete loader;
	
	// KDE 2.1: window title must be given explicitly
	setPlainCaption("Ksetiwatch");
	
  // status bar must be initialized before setting the central widget !
	statusBar()->insertItem("",0, 1);
	statusBar()->setItemAlignment(0, AlignLeft|AlignVCenter);
  	
	ktb = new KTabCtl(this);
	ana = new Analysis(ktb);
	ana->setMinimumSize(640, 130);
	ktb->addTab(ana, tlabel[0]);
	di = new DataInfo(&StarMap, ktb);
	di->setMinimumSize(640, 130);
	ktb->addTab(di, tlabel[1]);
	ui = new UserInfo(ktb);
	ui->setMinimumSize(640, 130);
	ktb->addTab(ui, tlabel[2]);
	cwu = new CompletedWUList(&StarMap, ktb);
	cwu->setMinimumSize(640, 130);
	ktb->addTab(cwu, tlabel[3]);
	opt = new Options(ktb);
	opt->setMinimumSize(640, 130);
	ktb->addTab(opt, tlabel[4]);
	abt = new About(ktb);
	abt->setMinimumSize(640, 130);
	ktb->addTab(abt, tlabel[5]);
	setCentralWidget(ktb);

  connect(ktb, SIGNAL(tabSelected(int)), this, SLOT(handleTabSelection(int)));
	connect(ana, SIGNAL(listModified()), cwu, SLOT(refreshTreeList()));
	connect(ana, SIGNAL(listModified()), di, SLOT(refreshList()));
	connect(ana, SIGNAL(listModified()), ui, SLOT(refreshList()));
	connect(cwu, SIGNAL(workUnitLogged()), this, SLOT(saveConfig()));

	startClients();
					
	ksdock = new DockWidget(this);
  connect(ana, SIGNAL(selectionChanged(SetiLoc*)), ksdock, SLOT(updateDockWidget(SetiLoc*)));
	connect(opt, SIGNAL(dockStatusChanged()), this, SLOT(toggleIcon()));
  // if ksetiwatch was closed in minimized state start it minimized again
  if(MINIMIZETOPANEL) ksdock->dock();
	}
	
Ksetiwatch::~Ksetiwatch()
{
// clear the list, otherwise there may be a segfault on exit
SetiList.clear();
}

void Ksetiwatch::closeEvent(QCloseEvent *e)
{
stopClients();
saveConfig();
KMainWindow::closeEvent( e );
}

void Ksetiwatch::saveProperties(KConfig*)
{
saveConfig();
}

bool Ksetiwatch::event(QEvent *e)
{
switch( (int)e->type() )
	{
	case QEvent::Hide:
		{
		if(MINIMIZETOPANEL)
			{
			SetiLoc* loc = getLocation(SetiLoc::AnalysisList, ana->selectedItem());
			ksdock->dock(loc);
			this->hide();
			}
		startmin = true;
		break;
		}
	case QEvent::Show:
		{
		startmin = false;
		break;
		}
	}
return KMainWindow::event( e );
}

void Ksetiwatch::saveConfig()
	{
	QString entry;
	
	config = kapp->config();

	config->setGroup("General Options");
	QRect r(pos().x(), pos().y(), size().width(), size().height());
	config->writeEntry("WindowSize", r);
	config->writeEntry("RefreshInterval", RefreshInterval*1000);
	config->writeEntry("TimeFormat", HMS);
	config->writeEntry("NewPeak_Record", NEWPEAK_RECORD);
	config->writeEntry("NewPeak_CurrentWU", NEWPEAK_CURRENTWU);
	config->writeEntry("MinimizeToPanel", MINIMIZETOPANEL);
	config->writeEntry("DrawGrid", DRAWGRID);
	config->writeEntry("StartMinimized", startmin);
	config->writeEntry("MarkerSize", MARKER_SIZE);
	config->writeEntry("FillMarker", FILL_MARKER);
	config->writeEntry("ShowText", SHOW_TEXT);
		
	config->setGroup("Seti Locations");
  int count = SetiList.count();
  config->writeEntry("count", count);

  SetiLoc *loc;
  int i = 1;
	for( loc=SetiList.first(); loc != 0; loc=SetiList.next() )
		{
		LocSettings ls = loc->options();
		entry.sprintf("Location_%d",i);
		config->writeEntry(entry, ls.description);
		entry.sprintf("Directory_%d",i);
		config->writeEntry(entry, ls.directory);
		entry.sprintf("Color_%d",i);
		config->writeEntry(entry, ls.color);
		entry.sprintf("Result_Timestamp_%d",i);
		config->writeEntry(entry, loc->timestamp());
		entry.sprintf("Startup_%d",i);
    config->writeEntry(entry, ls.startSeti);
    entry.sprintf("StopAtLogout_%d", i);
    config->writeEntry(entry, ls.stopSeti);
    entry.sprintf("CommandLine_Arguments_%d",i);
    config->writeEntry(entry, ls.arguments);
    entry.sprintf("Arg_StopAfterProcess_%d", i);
    config->writeEntry(entry, ls.stopAfterProcess);
    entry.sprintf("Arg_StopAfterSend_%d", i);
    config->writeEntry(entry, ls.stopAfterSend);
    entry.sprintf("Arg_Email_%d", i);
    config->writeEntry(entry, ls.email);
    entry.sprintf("Arg_Graphics_%d", i);
    config->writeEntry(entry, ls.graphics);
		entry.sprintf("LogWU_%d",i);
		config->writeEntry(entry, ls.log);
    entry.sprintf("RedirLog_%d", i);
    config->writeEntry(entry, ls.redirectLog);			
    entry.sprintf("LogDirectory_%d", i);
    config->writeEntry(entry, ls.logDirectory);
		i++;
		}		

  config->setGroup("Record Scores");
  // this is to avoid rounding errors
  entry.sprintf("%f", Record.spike.power);
  config->writeEntry("Spike", entry);
  config->writeEntry("Spike_ChirpRate", Record.spike.chirprate);
  config->writeEntry("Spike_WUName", Record.spike.wu_name);
  // this is to avoid rounding errors
  entry.sprintf("%f", Record.gaussian.score);
  config->writeEntry("Gaussian", entry);
  config->writeEntry("Gaussian_Power", Record.gaussian.power);
  config->writeEntry("Gaussian_Chisq", Record.gaussian.chisq);
  config->writeEntry("Gaussian_ChirpRate", Record.gaussian.chirprate);
  config->writeEntry("Gaussian_WUName", Record.gaussian.wu_name);
  // this is to avoid rounding errors
  entry.sprintf("%f", Record.pulse.score);
  config->writeEntry("Pulse", entry);
  config->writeEntry("Pulse_Power", Record.pulse.power);
  config->writeEntry("Pulse_Period", Record.pulse.period);
  config->writeEntry("Pulse_ChirpRate", Record.pulse.chirprate);
  config->writeEntry("Pulse_WUName", Record.pulse.wu_name);
  // this is to avoid rounding errors
  entry.sprintf("%f", Record.triplet.score);
  config->writeEntry("Triplet", entry);
  config->writeEntry("Triplet_Power", Record.triplet.power);
  config->writeEntry("Triplet_Period", Record.triplet.period);
  config->writeEntry("Triplet_ChirpRate", Record.triplet.chirprate);
  config->writeEntry("Triplet_WUName", Record.triplet.wu_name);

  // write the config to disk immediately and not at shutdown
  config->sync();
  }

void Ksetiwatch::readConfig()
	{
	QString id;
	
	config = kapp->config();

	config->setGroup("General Options");
	QRect sdefault(0, 0, 640, 165);
  QRect s = config->readRectEntry("WindowSize", &sdefault);
  this->setGeometry(s);
  RefreshInterval   = config->readNumEntry("RefreshInterval", 15000);
  // convert to seconds
  RefreshInterval /= 1000;
  HMS               = config->readBoolEntry("TimeFormat", true);
  NEWPEAK_RECORD    = config->readBoolEntry("NewPeak_Record", false);
  NEWPEAK_CURRENTWU = config->readBoolEntry("NewPeak_CurrentWU", false);
  MINIMIZETOPANEL   = config->readBoolEntry("MinimizeToPanel", false);
  DRAWGRID          = config->readBoolEntry("DrawGrid", true);
  startmin          = config->readBoolEntry("StartMinimized", false);
  MARKER_SIZE       = config->readNumEntry("MarkerSize", 2);
  FILL_MARKER       = config->readBoolEntry("FillMarker", true);
  SHOW_TEXT         = config->readBoolEntry("ShowText", true);

	config->setGroup("Seti Locations");
	int count = config->readNumEntry("count");
	
	if(count > 0)
		{
		for(int i=1;i<=count;i++)
			{
			LocSettings ls;
			id.sprintf("Directory_%d", i);
			ls.directory = config->readEntry(id);
			id.sprintf("Location_%d", i);
			ls.description = config->readEntry(id);
			id.sprintf("Color_%d", i);
			ls.color = config->readColorEntry(id);
			id.sprintf("Startup_%d", i);
			ls.startSeti = config->readBoolEntry(id, false);
			id.sprintf("StopAtLogout_%d", i);
			ls.stopSeti = config->readBoolEntry(id, false);
			id.sprintf("CommandLine_Arguments_%d", i);
			ls.arguments = config->readEntry(id, "");
			id.sprintf("Arg_StopAfterProcess_%d", i);
			ls.stopAfterProcess = config->readBoolEntry(id, false);
			id.sprintf("Arg_StopAfterSend_%d", i);
			ls.stopAfterSend = config->readBoolEntry(id, false);
			id.sprintf("Arg_Email_%d", i);
			ls.email = config->readBoolEntry(id, false);
			id.sprintf("Arg_Graphics_%d", i);
			ls.graphics = config->readBoolEntry(id, false);
			id.sprintf("LogWU_%d", i);
			ls.log = config->readBoolEntry(id, true);
			id.sprintf("RedirLog_%d", i);
			ls.redirectLog = config->readBoolEntry(id, false);			
			id.sprintf("LogDirectory_%d", i);
			ls.logDirectory = config->readEntry(id, "");
			SetiLoc *loc = new SetiLoc(ls.directory);
			loc->setRefreshInterval(RefreshInterval);
			// Due to a bug in the kdelibs prior to version 2.1 setGroup()
			// has to be called here once again.
      config->setGroup("Seti Locations");
			id.sprintf("Result_Timestamp_%d", i);
			loc->setTimestamp(config->readEntry(id, ""));
			loc->setOptions(ls);
			SetiList.append(loc);			
			}
		}

  config->setGroup("Record Scores");
	Record.spike.power        = config->readDoubleNumEntry("Spike", 0.0);
	Record.spike.chirprate    = config->readDoubleNumEntry("Spike_ChirpRate", 0.0);		
	Record.spike.wu_name      = config->readEntry("Spike_WUName", "unknown");
	Record.gaussian.score     = config->readDoubleNumEntry("Gaussian", 0.0);
	Record.gaussian.power     = config->readDoubleNumEntry("Gaussian_Power", 0.0);
	Record.gaussian.chisq     = config->readDoubleNumEntry("Gaussian_Chisq", 0.0);
	Record.gaussian.chirprate = config->readDoubleNumEntry("Gaussian_ChirpRate", 0.0);
	Record.gaussian.wu_name   = config->readEntry("Gaussian_WUName", "unknown");
	Record.pulse.score        = config->readDoubleNumEntry("Pulse", 0.0);
	Record.pulse.power        = config->readDoubleNumEntry("Pulse_Power", 0.0);
	Record.pulse.period       = config->readDoubleNumEntry("Pulse_Chisq", 0.0);
	Record.pulse.chirprate    = config->readDoubleNumEntry("Pulse_ChirpRate", 0.0);
	Record.pulse.wu_name      = config->readEntry("Pulse_WUName", "unknown");
	Record.triplet.score      = config->readDoubleNumEntry("Triplet", 0.0);
	Record.triplet.power      = config->readDoubleNumEntry("Triplet_Power", 0.0);
	Record.triplet.period     = config->readDoubleNumEntry("Triplet_Chisq", 0.0);
	Record.triplet.chirprate  = config->readDoubleNumEntry("Triplet_ChirpRate", 0.0);
	Record.triplet.wu_name    = config->readEntry("Triplet_WUName", "unknown");
	}

void Ksetiwatch::handleTabSelection(int id)
{
switch(id)
  {
  case SetiLoc::AnalysisList:
    statusBar()->changeItem(i18n("Press the right mouse button to edit the list."), 0);
    //ana->refreshList();
    break;
  case SetiLoc::DataInfoList:
    statusBar()->changeItem(i18n("Ready."), 0);
    //di->refreshList();
    break;
  case SetiLoc::UserInfoList:
    statusBar()->changeItem(i18n("Ready."), 0);
    //ui->refreshList();
    break;
  case 3: // Completed Work Units
    statusBar()->changeItem(i18n("Right click for options."), 0);
    break;
	default:
    statusBar()->changeItem(i18n("Ready."), 0);
    break;
	}
}
				
/** Starts the SETI@home clients if the startup switch is on. */
void Ksetiwatch::startClients()
{
SetiLoc* loc;

for( loc=SetiList.first(); loc != 0; loc=SetiList.next() )
	{
	if(loc->optionStartSeti() && loc->isClientRunning(0, true) == false)
	  loc->startClient();
	}
}

/** Stops the SETI@home clients if the stop switch is checked. */
void Ksetiwatch::stopClients()
{
SetiLoc* loc;

for( loc=SetiList.first(); loc != 0; loc=SetiList.next() )
	{
	if(loc->optionStopSeti() && loc->isClientRunning(0, true))
	  loc->stopClient();
	}
}

/** Returns the corresponding SetiLoc entry from
		a QListView item in the Analysis list. */
SetiLoc* Ksetiwatch::getLocation(int list, QListViewItem* it)
{
SetiLoc *loc = 0;

if(it)
	{
	// identify corresponding SetiLoc item
	for(loc=SetiList.first(); loc != 0; loc=SetiList.next() )
		{
		if(loc->item(list) == it) break;
		}
	}
return( loc );
}

/** Toggles dock icon on or off when the user makes changes in the options. */
void Ksetiwatch::toggleIcon()
{
if(MINIMIZETOPANEL)
	ksdock->dock();
else
	ksdock->undock();
}

#include "ksetiwatch.moc"

