/***************************************************************************
                          pulseplot.cpp  -  description
                             -------------------
    begin                : Mon Oct 23 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>

#include "pulseplot.h"

PulsePlot::PulsePlot(SetiLoc* loc, QWidget *parent, const char *name ) : SetiGraph(loc,true,false,parent,name)
{
// Make an array twice the size of the actual pulse data. Pulse data will be copied
// twice into that array.
pulseData.resize(1024);

// connect the SetiLoc signal to the new Gaussian slot of this widget.
location = loc;
connect(location, SIGNAL(newPulse(SetiLoc*)), this, SLOT(showNewPulseData(SetiLoc*)));

QString title;
title.sprintf(i18n("Top Pulse for %s (right-click for options)"), (const char*)loc->location());
setCaption(title);
setBackgroundColor(black);
resize(350, 200);
setMinimumSize(150, 100);

setTextPosition(SetiGraph::TopRight);

// prepare data for display
showNewPulseData(location);
}

PulsePlot::~PulsePlot()
{
}

/////////////////////////////////////////////////////////////////////////////
void PulsePlot::showNewPulseData(SetiLoc* loc)
{
if(loc == location)
	{
	top = (WUScore*)location->topScore();
	// convert int to double and make a copy in the upper 512 array elements
	for(int i=0;i<512;i++)
	  {
	  pulseData[i] = (double)top->pulse_data[i];	
    pulseData[i+512] = pulseData[i];
    }
	setCurve(pulseData);
	
  // generate the info text
  QString it;
  it.sprintf("power : %f\n"
             "mean  : %f\n"
             "period: %f\n"
             "score : %f",
             top->pulse_power,
             top->pulse_mean,
             top->pulse_period,
             top->pulse
             );
  setInfoText(it);

	repaint();
	}
}
