#ifndef __KPSCoordFrame_H__
#define __KPSCoordFrame_H__

#include "kpview.h"
#include "kpsprite.h"
#include "kpcoords.h"

class QSize;
class KPS2D;

class KPSCoordFrame : public KPSprite
{
  Q_OBJECT

  friend KPS2D;

 public:

  /**
   * Create a coordinate frame.
   **/
  KPSCoordFrame (KPView *view, KPCoords *coords, 
	    int z=0);


  /**
   * Extensions to the frame (text overspill) 
   * This is used because the frame size and plot size are
   *  interdependent.  "overSpill()" is the independent set of numbers.
   * (actually, half of that number)
   **/
  QSize overSpill (void) 
    { return QSize (tickxw, tickyh); }



  /**
   * Recompute *size and tick?? variables.
   * (used by kps2d::resizeEvent())
   **/
  void computeSizes(void);

  /**
   * Installs the default RMB menu.
   **/
  void installDefaultRMBMenu (void);


 protected:
  virtual void draw(QPainter&);
  virtual void setRect();
  QFont tickfont;
  int tickxw, tickxh;
  int tickyw, tickyh;
  double pointsize0;
  KPCoords *kcoords;

  virtual void resizeEvent (QResizeEvent *);
  void computeTextSize(void);

  /**
   * The next (and maybe current) height (width) of the 
   *  X (Y) axis.
   **/
  QSize girth () { return qsgirth; }

  
  /**
   * Call this either side of X(), Y(), or Image() value changes.
   */
  virtual void addToChunks();

  protected slots:
    void slotCoords();                                                          
 private:
  QRect brectinner;
  double framesize0, ticksize0; // a percentage
  int framesize, framesizeo2, bboxsize, ticksize, ticksizeo2;
  int decplaces; //# decimal places for labels
  
  QSize qsgirth;
  
  bool blabels, bticks;

};

#endif
