
#ifndef __KPCOORDS_H__
#define __KPCOORDS_H__

#include <klined.h>

class KPCoordsProp;

/**
 * Store and retrive coords in rect. or polar coords.
 *  Only compute/convert coords. when necessary (to save time).  Use
 *  inline functions to retrieve stored values.
 *
 *  cxmin, etc. are the plot-coordinates
 *  owidth, etc. are the size of the plot object in pixels
 **/
class KPCoords
{
 public:
  /**
   * Don't ever set <i>_owidth</i> or <i>_oheight</i> to 0.
   **/
  KPCoords ();
  KPCoords (double _cxmin, double _cxmax, double _cymin, double _cymax,
	   double _ccrossx=0, double _ccrossy=0,
	    int _ox0=0, int _oy0=0, int _owidth=1, int _oheight=1);

  /**
   * Make a KPCoords from its properties dialog.
   **/
  KPCoords (KPCoordsProp *);

  double cxmin () const {return cminx;}
  double cxmax () const {return cmaxx;}
  double cymin () const {return cminy;}
  double cymax () const {return cmaxy;}


  void setCxmin (double _cxmin);
  void setCxmax (double _cxmax);
  void setCymin (double _cymin);
  void setCymax (double _cmax);

  /**
   * Set the default ticks for these coordinates.
   **/
  void defaultTicks(void);

  /**
   * oX0() and oY0() are pixel-valued (global) offsets.
   **/

  int oX0 (void) { return x0; }
  int oY0 (void) { return y0; }
  int owidth (void) { return width; }
  int oheight (void) { return height; }

  void setX0 (int _ox0);
  void setY0 (int _oy0);

  double ccrossx (void) const {return crossx;}
  double ccrossy (void) const {return crossy;}

  void setCCrossx (double cx) {crossx=cx;}
  void setCCrossy (double cy) {crossy=cy;}

  void setWidth (int _owidth);
  void setHeight (int _oheight);

  void setXTick (double xspace);
  void setYTick (double yspace);

  double xTickSpacing (void) const { return xtickspc; }
  double yTickSpacing (void) const { return ytickspc; }

  int xc_to_o (double x)
    {return x0 + (int) ((x-cxmin())/xratio);}
  int yc_to_o (double y)
    {return y0 + height -  
       (int) (((y-cymin())/yratio));}

  double xo_to_c (int x)
    {return (x - x0)*xratio + cxmin();}
  double yo_to_c (int y)
    {return (-y + y0 + height)*yratio + cymin();}


 private:
  double cminx, cmaxx, cminy, cmaxy;
  //xratio = (cmaxx-xminx)/width, similarly for yratio
  double xratio, yratio, crossx, crossy;
  int width, height, x0, y0;
  double xtickspc, ytickspc;

  void setXRatio (void) { xratio = (cxmax() - cxmin())/(double)width; }
  void setYRatio (void) { yratio = (cymax() - cymin())/(double)height; }
  void setDefaults (void);

};



#include <stdlib.h>

#include <qwidget.h>

#include <klined.h>

class KPCoordsProp : public QWidget
{
  Q_OBJECT 

  friend KPCoords;

 public:
    KPCoordsProp (KPCoords *, QWidget *parent, const char *name=0, WFlags f=0);
  
  /**
   * Minimum x value.
   **/
  double xMin (void) { return atof (lexmin->text()); }

  /**
   * Maximum x value.
   **/
  double xMax (void) { return atof(lexmax->text()); }
  
  /**
   * Minimum y value.
   **/
  double yMin (void) { return atof(leymin->text()); }
  
  /**
   * Maximum y value.
   **/
  double yMax (void) { return atof(leymax->text()); }
  
  /**
   * X value where axes cross.
   **/
  double xCross (void) { return atof(lexcross->text()); }
  
  /**
   * Y value where axes cross.
   **/
  double yCross (void) { return atof(lexcross->text()); }
  
  /**
   * X axis tick spacing.
   **/
  double xTick (void) { return atof(lextick->text()); }

  /**
   * Y axis tick spacing.
   **/
  double yTick (void) { return atof(leytick->text()); }


protected:
  KLineEdit *lexmin, *lexmax, *leymin, *leymax, *lexcross, *leycross,
    *lextick, *leytick;
  KPCoords *coords;

  KPCoords *origCoords (void) { return coords; }

  protected slots:
    void slotDefault ();
};

#endif
