#ifndef __KPCOLORTABLE_H__
#define __KPCOLORTABLE_H__


#include <stdio.h>


#include <qlist.h>
#include <qcolor.h>

struct KPCTEntry
{
  QColor color;
  double start;
};

#if QT_VERSION<200
class KPCTable : public QList<KPCTEntry>
{
 public:
//  KPCTable ();
  
 protected:
  int compareItems (GCI a, GCI b)
    { double t;
    return (t=((KPCTEntry*) a)->start - ((KPCTEntry *)b)->start) > 0 ? 1 :
      (t < 0 ? -1 : 0);}

};

#else //QT_VERSION

class KPCTable : public QList<KPCTEntry>
{
 public:
  KPCTable () : QList() {}
  
 protected:
  int compareItems (Item a, Item b)
    { double t;
    return (t=((KPCTEntry*) a)->start - ((KPCTEntry *)b)->start) > 0 ? 1 :
      (t < 0 ? -1 : 0);}

};
#endif

class KPColorTable
{
public:
  /**
   * We have a scale, [min, max).  Intervals within this scale 
   *  can be associated with differentcolors by using addColor().
   */
  KPColorTable (double min, double max);

  KPColorTable () : min (0), max(1) {}

  /**
   * Set the minimum.
   **/
  //  void setMin
  /**
   * This color will take up the range [start, start of next color).
   *
   * FALSE is returned if start is out of range.
   **/
  bool addColor (double start, QColor);

  /**
   * Returns the color associated with the number c.
   **/
  QColor color (double c);


protected:
  double min, max;
  KPCTable table;
#if QT_VERSION>=200
  bool sorted;
#endif
};

#endif
