# Clearly from the kexample/kless directory!
# Adapted for kplot by David Sweet
#
# These 10 paths are KDE specific. Use them:
# kde_htmldir       Where your docs should go to. (contains lang subdirs)
# kde_appsdir       Where your application file (.kdelnk) should go to. 
# kde_icondir       Where your icon should go to.
# kde_sounddir      Where system sounds should go to.
# kde_datadir       Where you install application data. (Use a subdir)
# kde_locale        Where translation files should go to.(contains lang subdirs)
# kde_cgidir        Where cgi-bin executables should go to.
# kde_confdir       Where config files should go to.
# kde_mimedir       Where mimetypes should go to.
# kde_toolbardir    Where general toolbar icons should go to.
# kde_wallpaperdir  Where general wallpapers should go to.

CXXFLAGS = -O2 -Wall -pedantic

# set the include path for X, qt and KDE
INCLUDES=  -I../QwSpriteFieldKP -I../kplotw -I../kpcomm $(all_includes)

# claim, which subdirectories you want to install
# if you don't have subdirectories, comment it
# SUBDIRS = 

####### This part is very kless specific
# you can add here more. This one gets installed 
bin_PROGRAMS = 	kpsimple

# Which sources should be compiled for kless.
kpsimple_SOURCES = main.cpp 

kpsimple_METASOURCES =  

# the library search path. 
#KDE 1.x version
kpsimple_LDFLAGS = $(all_libraries) $(KDE_RPATH)

# the libraries to link against. Be aware of the order. First the libraries,
# that depend on the following ones.

kpsimple_LDADD   = $(LIB_KFILE)
# ../QwSpriteFieldKP/libQwSpriteFieldKP.la ../kplotw/libkplotw.la ../kpcomm/libkpcomm.la

#KDE 2.0 version
#kpsimple_LDADD   = $(LIB_KFILE) -lQwSpriteField -lkpsimplew

# this option you can leave out. Just, if you use "make dist", you need it
noinst_HEADERS =
# kpsimple.h

# if you "make distclean", this files get removed. If you want to remove
# them while "make clean", use CLEANFILES
DISTCLEANFILES = $(kpsimple_METASOURCES)

CLEANFILES = *.ps *~

# make messages.po. Move this one to ../po/ and "make merge" in po
# the -x is for skipping messages already translated in kdelibs
messages:
	$(XGETTEXT) -C -ki18n -x $(includedir)/kde.pot $(kpsimple_SOURCES) && mv messages.po ../po/kpsimple.pot

kdelnkdir = $(kde_appsdir)/Utilities
kdelnk_DATA = kpsimple.kdelnk

icondir = $(kde_icondir)
icon_DATA = kpsimple.xpm

# just install datas here. Use install-exec-local for scripts and etc.
# the binary itself is already installed from automake
# use mkinstalldirs, not "install -d"
# don't install a list of file. Just one file per install.
# if you have more of them, create a subdirectory with an extra Makefile 
install-data-local: 
	$(mkinstalldirs) $(kde_icondir)
	$(INSTALL_DATA) $(kde_icondir)/kpsimple.xpm
#	$(INSTALL_DATA) $(srcdir)/mini-kless.xpm $(kde_minidir)/kless.xpm

# remove ALL you have installed in install-data-local or install-exec-local
uninstall-local:
	-rm -f $(kde_icondir)/kpsimple.xpm


