/*************************************************/
/* methods for class XObject                     */
/*                                               */
/* pixmap management for objects on the screen   */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpixmap.h>

#include <string.h>
#include <math.h>
#include <xobject.h>
#include <xwire.h>
#include <klogic.h>

/***************************************************/
/* methods of XObject                              */
/***************************************************/
XObject::XObject()
{	img = new QPixmap(1, 1);
	voffset = VOFFSET;
	hoffset = 0;
	initPos(0,0);
	selected = 0;
}

XObject::~XObject()
{	delete img;
}

// set vertical offset of image
void XObject::setVOffset(int val)
{
	voffset = val;
}

// set vertical offset of image
void XObject::setHOffset(int val)
{
	hoffset = val;
}

// get vertical offset of image
int XObject::getVOffset()
{
	return voffset;
}

// set iinitial position on the screen
void XObject::initPos(int x, int y)
{	int w, h;

	x = x / GRID * GRID;
	y = y / GRID * GRID;
	w = newPos.width();
	h = newPos.height();
	delta.setX(0);
	delta.setY(0);
	newPos.setX(x - hoffset);
	newPos.setY(y - voffset);
	oldPos.setX(x - hoffset);
	oldPos.setY(y - voffset);
	newPos.setWidth(w);
	newPos.setHeight(h);
	oldPos.setWidth(w);
	oldPos.setHeight(h);
}

// move on the screen
void XObject::addPos(int x, int y)
{	int w, h;

	x = x * GRID / GRID;
	y = y * GRID / GRID;

	w = newPos.width();
	h = newPos.height();
	newPos.setX(newPos.x() + x) ;
	newPos.setY(newPos.y() + y) ;
	newPos.setWidth(w);
	newPos.setHeight(h);
}

int XObject::setPos(QPoint pos)
{
	int dx, dy;
	int w, h;

	w = newPos.width();
	h = newPos.height();

	// sub delta to given point (delta: difference between top left of object and mouse)
	pos.setX(pos.x() + delta.x());
	pos.setY(pos.y() + delta.y());
	// check for req movement
	dx = (pos.x() - newPos.x()) / GRID;
	dy = (pos.y() - newPos.y()) / GRID;
	if (dx != 0 || dy != 0) {
		// ok, move the object
		dx = (pos.x() / GRID) * GRID;
		dy = (pos.y() / GRID) * GRID;
		newPos.setX(dx - hoffset);
		newPos.setY(dy - voffset);
		newPos.setWidth(w);
		newPos.setHeight(h);
		return 1;
	}
	return 0;
}

QRect XObject::getPos()
{	return newPos;
}

QRect XObject::getOldPos()
{	return oldPos;
}

int XObject::contains(QPoint pt, int in_size, int out_size)
{	QRect r = newPos;
	int w;

	// subtract input- and output-region from image-size
	w = r.width() - in_size - out_size;
	r.setX(r.x() + in_size);
	r.setWidth(w);
	if (r.contains(pt)) {
		// calculate delta's (mouse <-> object)
		delta.setX(newPos.x() - pt.x());
		delta.setY(newPos.y() - pt.y());
		return 1;
	}
	return 0;
}

int XObject::contains(QRect pos)
{	if (newPos.intersects(pos)) {
		return 1;
	}
	return 0;
}

void XObject::select(int f)
{
	if (f) selected = 1;
	else selected = 0;
}

int XObject::isSelected()
{
	return selected;
}

void XObject::erase(QPainter *p)
{	int i,j;

	p->fillRect(oldPos, Qt::white);
	p->setPen(Qt::black);
	for(i=oldPos.x() + hoffset - GRID; i < oldPos.x() + oldPos.width() + hoffset + GRID; i += GRID)
		for(j=oldPos.y() + voffset; j < oldPos.y() + voffset + oldPos.height(); j += GRID)
			p->drawPoint(i,j);
	oldPos = newPos;
}

void XObject::drawImage(QPaintDevice *paintd, QPainter *p)
{	bitBlt(paintd, newPos.x(), newPos.y(), img);
	if (selected) {
		p->setPen(Qt::green);
		p->setBrush(Qt::NoBrush);
		p->drawRect(newPos.x(), newPos.y(), newPos.width(), newPos.height());
	}
}

void XObject::setImage()
{	QRect r;

	r = img->rect();
	newPos.setWidth(r.width());
	newPos.setHeight(r.height());
	oldPos.setWidth(r.width());
	oldPos.setHeight(r.height());
}

QPixmap *XObject::getImage()
{	return img;
}

void XObject::setOrigin()
{	origin.setX(newPos.x());
	origin.setY(newPos.y());
}

void XObject::toOrigin()
{
	int w, h;

	w = newPos.width();
	h = newPos.height();
	newPos.setX(origin.x());
	newPos.setY(origin.y());
	newPos.setWidth(w);
	newPos.setHeight(h);
}

int  XObject::isOrigin(QPoint pt)
{	QRect r(origin.x(), origin.y(), newPos.width(), newPos.height());

	if (r.contains(pt))
		return 1;
	return 0;
}

