/*************************************************/
/* methods for class PwrProp                     */
/*                                               */
/* power source properties dialog                */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <qdialog.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <klineedit.h>

#include <klogic.h>
#include <xdevice.h>
#include <xnet.h>
#include <propPwr.h>

#include "propPwr.moc"

PwrProp::PwrProp(QWidget *parent, const char *name, XDeviceNet *_dnet, XDevice *_dev)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    dev = _dev;
    dnet = _dnet;

    label0 = new QLabel(this, "label0_widget");
    label0->setGeometry(30, 10, 43, 20);
    label0->setText(klocale->translate("name"));
    devname = new KLineEdit(this, "devname_widget");
    devname->setGeometry(80, 10, 110, 20);
    devname->setEnabled(FALSE);
    devname->setText(dev->getText());

    bgPwr = new QButtonGroup(klocale->translate("output value"), this);
    bgPwr->setGeometry(40, 40, 130, 60);
    rbPlus = new QRadioButton(klocale->translate("high"), bgPwr);
    rbPlus->setGeometry(10,20, 100, 15);
    rbMinus = new QRadioButton(klocale->translate("low"), bgPwr);
    rbMinus->setGeometry(10,40, 100, 15);
    if (dev->output()) rbPlus->setChecked(TRUE);
    else rbMinus->setChecked(TRUE);

    bCancel = new QPushButton(this);
    bCancel->setGeometry(130, 120, 60, 30);
    bCancel->setText(klocale->translate("Cancel"));

    bOK = new QPushButton(this);
    bOK->setGeometry(20, 120, 60, 30);
    bOK->setDefault(TRUE);
    bOK->setText(klocale->translate("OK"));

    setCaption(name);
    setFixedSize(210, 170);

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void PwrProp::done(int r)
{
	if (r == Accepted) {
		if (rbPlus->isChecked()) {
			dev->setStaticInput(1);
			dev->setImage();
		}
		else {
			dev->setStaticInput(0);
			dev->setImage();
		}
	}
	QDialog::done(r);
}

