/*************************************************/
/* methods for class NameProp                    */
/*                                               */
/* name property dialog                          */
/*                                               */
/* Andreas Rostin                                */
/* 15.01.99                                      */
/*************************************************/
#include <qmessagebox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klineedit.h>

#include <klogic.h>
#include <xdevice.h>
#include <xnet.h>
#include <propName.h>

#include "propName.moc"

NameProp::NameProp(QWidget *parent, QString name, XDeviceNet *_dnet, XDevice *_dev)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    // main variable for this dialog:
    dev = _dev;
    dnet = _dnet;

    label0 = new QLabel((QWidget *)this, (QString)NULL);
    label0->setGeometry(30, 10, 43, 20);
    label0->setText(klocale->translate("name"));
    devname = new KLineEdit((QWidget *)this, (QString)NULL);
    devname->setGeometry(80, 10, 80, 20);
    devname->setCaption("(null)");
    if (dev->type() == XDevice::fIN || dev->type() == XDevice::fOUT)
	    devname->setMaxLength(4);

    bCancel = new QPushButton(this);
    bCancel->setGeometry(108, 50, 60, 25);
    bCancel->setText(klocale->translate("Cancel"));

    bOK = new QPushButton(this);
    bOK->setGeometry(25, 50, 60, 25);
    bOK->setDefault(true);
    bOK->setText(klocale->translate("OK"));

    setCaption(name);
    setFixedSize(195, 95);
    devname->setText(dev->getText());

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void NameProp::done(int r)
{
	if (r == Accepted) {
                // check/set new name
		QString s = dev->getText();
		if (0 != devname->text().compare(s)) {
			dnet->setText(dev->getID(), devname->text());
			dev->setImage();
			dnet->setImage();
                }
	}
	QDialog::done(r);
}

