#ifndef __PROPGLOB
#define __PROPGLOB

#include <qdialog.h>

class KLineEdit;

class QGroupBox;
class QLabel;
class QButtonGroup;
class QPushButton;
class QRadioButton;
class QCheckBox;

class GlobProp : public QDialog
{
    Q_OBJECT

public:
    GlobProp(QWidget *, const char *name, NetWidget *);

private slots:
    void undefChange(int);
    void invertedChange(int);
    void clockChange(int);
    void apply();

private:
    void done(int);

    NetWidget *netw;

    QGroupBox *gb_dev;
    QLabel *lsize;
    KLineEdit *defsize;
    QLabel *ldelay;
    KLineEdit *defdelay;
    QButtonGroup *bg_undef;
    QRadioButton *undef[2];
    QButtonGroup *bg_invert;
    QRadioButton *invert[2];
    QCheckBox *cb_display_name;

    QButtonGroup *bg_clock;
    QRadioButton *clock[4];
    QCheckBox *invert_trigger;

    QGroupBox *gb_sim;
    QLabel *lstepTime;
    KLineEdit *stepTime;
    QLabel *lburst;
    KLineEdit *burst;

    QPushButton *bApply;
    QPushButton *bCancel;
    QPushButton *bOK;

    int curr_clk;
    int curr_undef;
    int curr_invert;
};

#endif
