/*************************************************/
/* methods for class GlobProp                    */
/*                                               */
/* global properties dialog                      */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <klineedit.h>

#include <qgroupbox.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qvalidator.h>

#include <klogic.h>
#include <xdevice.h>
#include <netw.h>

#include <propGlob.h>
#include "propGlob.moc"

GlobProp::GlobProp(QWidget *parent, const char *name, NetWidget *_netw)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    QString value;

    netw = _netw;
//---> device settings
    gb_dev = new QGroupBox(klocale->translate("default device settings"), this);
    gb_dev->setGeometry(30, 30, 170, 260);

    lsize = new QLabel(gb_dev);
    lsize->setGeometry(30, 20, 70, 20);
    lsize->setText(klocale->translate("default size"));
    defsize = new KLineEdit(gb_dev);
    QIntValidator *vDefSize = new QIntValidator(defsize);
    defsize->setValidator(vDefSize);
    defsize->setGeometry(100, 20, 50, 20);
    defsize->setMaxLength(2);
    defsize->setText(value.setNum(XDevice::defSize()));

    ldelay = new QLabel(gb_dev);
    ldelay->setGeometry(20, 50, 80, 20);
    ldelay->setText(klocale->translate("default delay"));
    defdelay = new KLineEdit(gb_dev);
    QIntValidator *vDefDelay = new QIntValidator(defdelay);
    defdelay->setValidator(vDefDelay);
    defdelay->setGeometry(100, 50, 50, 20);
    defdelay->setMaxLength(2);
    defdelay->setText(value.setNum(Device::defDelay()));

    bg_invert = new QButtonGroup(klocale->translate("outputs inverted"), gb_dev);
    bg_invert->setGeometry(20, 80, 130, 60);
    invert[0] = new QRadioButton(klocale->translate("not inverted"), bg_invert);
    invert[0]->setGeometry(10,20, 100, 15);
    invert[1] = new QRadioButton(klocale->translate("inverted"), bg_invert);
    invert[1]->setGeometry(10,40, 100, 15);
    curr_invert = XDevice::isDefInverted();
    if (curr_invert)
        invert[1]->setChecked(TRUE);
    else
        invert[0]->setChecked(TRUE);
    bg_invert->insert(invert[0], 0);
    bg_invert->insert(invert[1], 1);

    bg_undef = new QButtonGroup(klocale->translate("undefined value"), gb_dev);
    bg_undef->setGeometry(20, 150, 130, 60);
    undef[0] = new QRadioButton(klocale->translate("Low"), bg_undef);
    undef[0]->setGeometry(10,20, 100, 15);
    undef[1] = new QRadioButton(klocale->translate("High"), bg_undef);
    undef[1]->setGeometry(10,40, 100, 15);
    curr_undef = Device::defUndefined();
    if (curr_undef)
        undef[1]->setChecked(TRUE);
    else
        undef[0]->setChecked(TRUE);
    bg_undef->insert(undef[0], 0);
    bg_undef->insert(undef[1], 1);

    cb_display_name = new QCheckBox(klocale->translate("display name"), gb_dev);
    cb_display_name->setGeometry(30, 225, 100, 15);
    if (XDevice::textDisplayedGlobal()) cb_display_name->setChecked(TRUE);
    else cb_display_name->setChecked(FALSE);

//<---

//---> clock settings
    bg_clock = new QButtonGroup(klocale->translate("default trigger (flip-flop)"), this);
    bg_clock->setGeometry(230, 30, 170, 135);

    clock[0] = new QRadioButton(klocale->translate("rising edge"), bg_clock);
    clock[0]->setGeometry(30,20, 100, 15);
    clock[1] = new QRadioButton(klocale->translate("falling edge"), bg_clock);
    clock[1]->setGeometry(30,40, 100, 15);
    clock[2] = new QRadioButton(klocale->translate("High value"), bg_clock);
    clock[2]->setGeometry(30,60, 100, 15);
    clock[3] = new QRadioButton(klocale->translate("Low value"), bg_clock);
    clock[3]->setGeometry(30,80, 100, 15);
    curr_clk = Device::defClock();
    clock[curr_clk]->setChecked(TRUE);
    invert_trigger = new QCheckBox(klocale->translate("reverse trigger"), this);
    invert_trigger->setGeometry(260,140, 100, 15);
    if (Device::triggerInverted()) invert_trigger->setChecked(TRUE);
    else invert_trigger->setChecked(FALSE);
    bg_clock->insert(clock[0], 0);
    bg_clock->insert(clock[1], 1);
    bg_clock->insert(clock[2], 2);
    bg_clock->insert(clock[3], 3);

//<---

//---> simulation settings
    gb_sim = new QGroupBox(klocale->translate("simulation"), this);
    gb_sim->setGeometry(230, 180, 170, 80);

    lstepTime = new QLabel(gb_sim);
    lstepTime->setGeometry(10, 20, 80, 20);
    lstepTime->setText(klocale->translate("speed (1/ms)"));
    stepTime = new KLineEdit(gb_sim);
    QIntValidator *vStepTime = new QIntValidator(stepTime);
    stepTime->setValidator(vStepTime);
    stepTime->setGeometry(100, 20, 50, 20);
    stepTime->setMaxLength(5);
    stepTime->setText(value.setNum(NetWidget::simTime()));

    lburst = new QLabel(gb_sim);
    lburst->setGeometry(10, 50, 80, 20);
    lburst->setText(klocale->translate("burst stepping"));
    burst = new KLineEdit(gb_sim);
    QIntValidator *vBurst = new QIntValidator(burst);
    burst->setValidator(vBurst);
    burst->setGeometry(100, 50, 50, 20);
    burst->setMaxLength(5);
    burst->setText(value.setNum(NetWidget::simBurst()));
//<---

    bCancel = new QPushButton(this);
    bCancel->setGeometry(290, 320, 90, 25);
    bCancel->setText(klocale->translate("Cancel"));

    bApply = new QPushButton(this);
    bApply->setGeometry(170, 320, 90, 25);
    bApply->setText(klocale->translate("Apply"));

    bOK = new QPushButton(this);
    bOK->setGeometry(50, 320, 90, 25);
    bOK->setDefault(TRUE);
    bOK->setText(klocale->translate("OK"));

    setCaption(name);
    setFixedSize(430, 370);

    connect(bg_undef, SIGNAL(clicked(int)), this, SLOT(undefChange(int)));
    connect(bg_invert, SIGNAL(clicked(int)), this, SLOT(invertedChange(int)));
    connect(bg_clock, SIGNAL(clicked(int)), this, SLOT(clockChange(int)));

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bApply, SIGNAL(clicked()), SLOT(apply()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

// does not apply changes to existing devices
void GlobProp::done(int r)
{	QString value;

	if (r == Accepted) {
		value = defdelay->text();
		Device::setDefDelay(value.toInt());
		value = defsize->text();
		XDevice::setDefSize(value.toInt());
		Device::setDefUndefined(curr_undef);
		XDevice::setDefInverted(curr_invert);
        	Device::setDefClock(curr_clk);
		if (invert_trigger->isChecked())
			Device::invertTrigger(1);
		else
			Device::invertTrigger(0);
		value = stepTime->text();
		if (value.toInt() != NetWidget::simTime()) {
			NetWidget::setSimTime(value.toInt());
		}
		value = burst->text();
		NetWidget::setSimBurst(value.toInt());
		if (cb_display_name->isChecked()) XDevice::displayTextGlobal(1);
		else XDevice::displayTextGlobal(0);
	}
	QDialog::done(r);
}

// apply changes to all existing devices
void GlobProp::apply()
{	QString value;

	// set new default values
	value = defdelay->text();
	Device::setDefDelay(value.toInt());
	value = defsize->text();
	XDevice::setDefSize(value.toInt());
	Device::setDefUndefined(curr_undef);
	XDevice::setDefInverted(curr_invert);
	Device::setDefClock(curr_clk);
	if (invert_trigger->isChecked())
		Device::invertTrigger(1);
	else
		Device::invertTrigger(0);
	value = stepTime->text();
	if (value.toInt() != NetWidget::simTime()) {
		NetWidget::setSimTime(value.toInt());
	}
	value = burst->text();
	NetWidget::setSimBurst(value.toInt());
	if (cb_display_name->isChecked()) XDevice::displayTextGlobal(1);
	else XDevice::displayTextGlobal(0);

	netw->applyDefaults();
}

void GlobProp::undefChange(int newi)
{
	curr_undef = newi;
}

void GlobProp::invertedChange(int newi)
{
	curr_invert = newi;
}

void GlobProp::clockChange(int clk)
{
	curr_clk = clk;
}

