#ifndef __OPSTACK_CLASS__
#define __OPSTACK_CLASS__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
class Device;
class QString;
class StackInfo; // see value.h
#include<value.h>
class Fifo;
template <class T> class list;

// operations
#define OP_BRACKET	'('
#define OP_AND		'&'
#define OP_OR		'+'
#define OP_XOR		'#'
#define OP_NOT		'/'
#define OP_NONE		'\10'
#define OP_NULL		'\11'

// operation types
#define OP_PARENTHESIS	0
#define OP_LR		1
#define OP_R		2

// error codes
#define STACK_NEG_ERROR	1
#define STACK_POS_ERROR	2
#define NTERM_ERROR	3
#define PAR_ERROR	4

// max. number of inputs for a static device
#define OP_MAXINP	100

class opStack: public value {
public:
	opStack(Device *, int, int);
	opStack();
	~opStack();

	void setEquation(char);				// set single operator as equation (no named inputs)
	void setEquation(char *);			// set equation
	void setEquation(const char *);			// set equation
	char * getEquation();				// return equation
	char * getEquation(const char *);		// return prefixed equation
	int hasEquation();				// return wether we have an equation or not

	void clear();					// clear calculation stack, reset parsing
	StackInfo parse();				// parse current equation, build calculation stack
	StackInfo parse(list<value> *, list<opStack> *);// parse current equation, check computation, build calculation stack (needs a dev)

	void push(int);					// push values to the calculation stack
	int calculate();				// calculate the stack, return the result (needs a dev)
	char * calculateSymbolic();			// calculate the stack symbolic, return the new equation
	char * calculateSymbolicNormalized(int, int);	// build minimal normalized equation, return the new equation

	const char * getSymbol(int);			// return the n-th symbol in the equation (each symbol only once, start with 0!)
	void getPatterns(char ***, int *, int ***, int *);// return a set of all possible patterns
	void getGroups(int ***, int **, int *);		// return a set of groups found in  patterns
							// the pointer may become invalid on further operations using the same instance!!
	int getResult();				// get result of the last calculation
	int shift();					// shift result into fifo
	void flush(int);				// flush fifo with a value

	void stackDump();				// debug
	void groupDump(int group_no, int **group, int *group_cnt);	// debug

	char * getOP(char *);				// return pointer to an operation contained in string
	int checkName(char *);				// check if string contains reserved characters and/or strings
	char ** getQueue();				// return parsed queue
	StackInfo ** getInfo();				// return info for the queue elements
	int getCounter();				// return number of elements in queue

	void setUndefined(int);
	int getUndefined();

	void setDelay(int);
	int getDelay();

	char hasStaticOP();				// true if equation contains a single operator

private:
	// methods used for parsing equations
	int parse(char *, int current_offset, int docnt = 0);
	// check that calculation stack is computational
	StackInfo check(list<value> *, list<opStack> *);

	inline int getBracket(char *);
	inline int getLeft(char *, char **);
	inline int getRight(char *, char **);
	inline void push(char *, int length, int current_offset);
	inline int opType(char);
	inline int needsParenthesis(char *, char);
	inline int pow2(int);
	inline int pow2complement(int, int);
	inline void calculatePattern();
	inline void scanInputList();
	inline void init();

	// the equation
	char *equation;
	char *tmp_equ;

	// calculation queue
	char **queue;
	int *queueid;
	StackInfo **queue_info;

	// total items in the queue
	int total;
	// max number of items for queue, stack and stack_info
	int maxitem;
	// total no of values in the stack
	int plane;

	// the owner of the queue
	Device *dev;

	// type of calculation: static (unique operation on all input values) or dynamic (equation based)
	char staticOP;

	// result of the last calculation
	int result;
	int old_result;
	int delayed_result;
	int delay;
	Fifo *result_fifo;

	// value for undefined results
	int undefined_result;

	// operation stack to push values
	int * stack;

	// analyze pattern
	char **input_list;
	int input_cnt;

	int *pattern_idx;
	int **patterns;
	char *daa_patterns;
	unsigned daa_patterns_dimensions[2]; 
	int *pattern;		// pointer to the current pattern, no memory to free!
	int pattern_cnt;

	int pattern_mode;

	// the groups found using the normalizing algorithm
	int **group;		// array of groups found
	int *group_size;	// size of groups held in int**group
	int group_cnt;		// total number of groups in int**group
	char *daa_group;	// pointer to use with free
	unsigned daa_group_dimensions[2];
};

#endif

