/*************************************************/
/* compatibility methods                         */
/*                                               */
/* Andreas Rostin                                */
/* 14.11.99                                      */
/*************************************************/
#include <stdio.h>
#include <string.h>
#include <qstring.h>
#include <klogic.h>
#include <xdevice.h>
#include <xnet.h>

// old file format (devices) has no 
int XDeviceNet::hist_isHist(QString s)
{	
	if(0 != (s.find((char)2, 0) + 1)) return 0;
	return 1;
}

int XDeviceNet::hist_importInstance(QString s)
{       int apos, epos;
	QString sid;
	int size;
        XDevice *d;

	epos = s.find(DLM, 0);
	if (epos == -1) return 0;       // no error!
	sid = s.mid(1, epos - 1);

	apos = epos + 1;
	epos = s.length();
	size = s.mid(apos, epos - apos).toInt();

        d = newDevice(XDevice::fNET, 10, 10);
	if (!d) fatal("unable to create initial sub circuit\n");
        if (d->size() != size) {
                d->setSize(size);
		d->setImage();
        }

	devmap.fileID(sid, d->getID());

	return 0;
}

int XDeviceNet::hist_importDevice(QString s, int select, int dx = 0, int dy = 0)
{       int apos, epos;
	int func;
	int size;
        int posx, posy;
        QString sid;
        QString devext;
        XDevice *d;
        int imageChanged = 0;
	char buf[1001];

        apos = 1;
        epos = s.find(DLM, 0);
        if (epos == -1) return -1;
        sid = s.mid(apos, epos - apos);

        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return -1;
        func = s.mid(apos, epos - apos).toInt();

        apos = epos + 1;
        epos = s.find(DLM, apos);
        if (epos == -1) return -1;
        size = s.mid(apos, epos - apos).toInt();

        apos = epos + 1;
        epos = s.length();
        devext = s.mid(apos, epos - apos);

        // create new device
        d = newDevice(func, 0, 0);
	if (!d) fatal("unable to create device with name <%s> and function <%d>\n", buf, func);
        if (d->size() != size) {
                d->setSize(size);
                imageChanged = 1;
        }
        if (select) d->select(1);

        // the rest of the string will be imported by the device, returning a string with the device-position
        devext = d->hist_string2device(devext);
        if (devext.isEmpty()) return -1;

        // restore device position (ugly in cause of the last old file format!)
        apos = 0;
        epos = devext.find(DLM, apos);
        if (epos == -1) return -1;
        posx = devext.mid(apos, epos - apos).toInt();
        posy = devext.right(devext.length() - epos - 1).toInt();
        // set initial position of the device
        d->initPos(posx + dx, posy + dy);
        d->setPos(QPoint(posx + dx, posy + dy));

	// < 4: has a clock
	if ((d->clock() < 4) && (func == XDevice::fRS)) {
		// remove all named inputs...
		while(named_input.First())
			removeInputName(named_input.First()->getID1());
		// ... and add the new ones
		addInputName("1S", 0);
		addInputName("C1", 2);
		addInputName("1R", 4);
	}

	devmap.fileID(sid, d->getID());

	setText(d->getID(), (char *)(const char *)sid);

	// set new image
	d->setImage();
	if (d->type() == fIN || d->type() == fOUT)
		setImage();

	d->parseEquation();

	setColor();

        return 0;
}

QString Device::hist_string2device(const char *s)
{       char *apos, *epos;
        int x,y;
        QString ret;

        ret.truncate(0);
        apos = (char *)s;

        if (function != fTXT) {
                // delay
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setDelay(atoi(apos));
                apos = epos + 1;

                // undefined value
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setUndef(atoi(apos));
                apos = epos + 1;

                // clock type
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setClock(atoi(apos));
                apos = epos + 1;

                // master ff flag
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setMaster(atoi(apos));
                apos = epos + 1;

                // oscillator on time
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setOszOn(atoi(apos));
                apos = epos + 1;

                // oscillator off time
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setOszOff(atoi(apos));
                apos = epos + 1;
        } else {
                // text
                if (!(epos = strchr(apos, 1))) return ret;
                *epos = '\0';
                setText(apos);
                apos = epos + 1;
        }

        // x position on the screen (useless!)
        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        x = atoi(apos);
        apos = epos + 1;

        // y position on the screen (useless here!)
        if (!(epos = strchr(apos, 1))) {                // text devices or old file format
                y = atoi(apos);
                ret.sprintf("%d%c%d", x, DLM, y);
                return ret;
        }
        *epos = '\0';
        y = atoi(apos);
        apos = epos + 1;
        ret.sprintf("%d%c%d", x, DLM, y);

        // ***** additional values since 23.09.99 *****

        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        flush(atoi(apos));
        apos = epos + 1;

        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        setStaticInput(atoi(apos));
        apos = epos + 1;

        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        //last_output_value = atoi(apos);
        apos = epos + 1;

        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        //internal_value = atoi(apos);
        apos = epos + 1;

        if (!(epos = strchr(apos, 1))) return ret;
        *epos = '\0';
        //last_internal_value = atoi(apos);
        apos = epos + 1;

        osz_curr_step = atoi(apos);

        return ret;
}


