/*************************************************/
/* member methods for class fifo                 */
/*                                               */
/* signal delay                                  */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <fifo.h>

enum {FALSE, TRUE};

Fifo::Fifo(int d)
{	_fifo = (int *)NULL;
	setDepth(d);
}

Fifo::~Fifo()
{	if (_fifo) free(_fifo);
}

void Fifo::setDepth(int d)
{
	if (_fifo) free (_fifo);
	_fifo = (int *)malloc(sizeof(int) * (d + 1));
	if (!_fifo) return;
	else _depth = d;
	bzero(_fifo, sizeof(int) * (d + 1));
}

int Fifo::depth()
{	return _depth;
}

void Fifo::flush(int val)
{	int i;

	for(i=0;i<=_depth;i++) _fifo[i] = val;
}

// shift queue by 1
// insert newval on first place
// return dropped value
int Fifo::put(int newval)
{	int i;
	int ret = _fifo[_depth];

	for(i=_depth;i > 0;i--) _fifo[i] = _fifo[i - 1];
	_fifo[0] = newval;
	if (_depth > 0) _fifo[_depth] = _fifo[_depth - 1];
	return ret;
}

int Fifo::get()
{
	return _fifo[_depth];
}
